@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetStorageAppliancePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property storageApplianceName The name of the storage appliance.
 */
public data class GetStorageAppliancePlainArgs(
    public val resourceGroupName: String,
    public val storageApplianceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetStorageAppliancePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetStorageAppliancePlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetStorageAppliancePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .storageApplianceName(storageApplianceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStorageAppliancePlainArgs].
 */
@PulumiTagMarker
public class GetStorageAppliancePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var storageApplianceName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iamftmsytgxypqvl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the storage appliance.
     */
    @JvmName("tlaeqnqtiikkldch")
    public suspend fun storageApplianceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.storageApplianceName = mapped
    }

    internal fun build(): GetStorageAppliancePlainArgs = GetStorageAppliancePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        storageApplianceName = storageApplianceName ?: throw
            PulumiNullFieldException("storageApplianceName"),
    )
}
