@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.GetVolumePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property volumeName The name of the volume.
 */
public data class GetVolumePlainArgs(
    public val resourceGroupName: String,
    public val volumeName: String,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.GetVolumePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.GetVolumePlainArgs =
        com.pulumi.azurenative.networkcloud.inputs.GetVolumePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .volumeName(volumeName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVolumePlainArgs].
 */
@PulumiTagMarker
public class GetVolumePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var volumeName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uyfklvxmpbbstucu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the volume.
     */
    @JvmName("vubutldihwwjfovd")
    public suspend fun volumeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeName = mapped
    }

    internal fun build(): GetVolumePlainArgs = GetVolumePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        volumeName = volumeName ?: throw PulumiNullFieldException("volumeName"),
    )
}
