@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.SshPublicKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyData The SSH public key data.
 */
public data class SshPublicKeyArgs(
    public val keyData: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.SshPublicKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.SshPublicKeyArgs =
        com.pulumi.azurenative.networkcloud.inputs.SshPublicKeyArgs.builder()
            .keyData(keyData.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SshPublicKeyArgs].
 */
@PulumiTagMarker
public class SshPublicKeyArgsBuilder internal constructor() {
    private var keyData: Output<String>? = null

    /**
     * @param value The SSH public key data.
     */
    @JvmName("kqkraigtychdgyaf")
    public suspend fun keyData(`value`: Output<String>) {
        this.keyData = value
    }

    /**
     * @param value The SSH public key data.
     */
    @JvmName("dbbqqceeiavfnfoh")
    public suspend fun keyData(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyData = mapped
    }

    internal fun build(): SshPublicKeyArgs = SshPublicKeyArgs(
        keyData = keyData ?: throw PulumiNullFieldException("keyData"),
    )
}
