@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.inputs

import com.pulumi.azurenative.networkcloud.inputs.StorageProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property osDisk The disk to use with this virtual machine.
 * @property volumeAttachments The resource IDs of volumes that are requested to be attached to the virtual machine.
 */
public data class StorageProfileArgs(
    public val osDisk: Output<OsDiskArgs>,
    public val volumeAttachments: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.networkcloud.inputs.StorageProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.networkcloud.inputs.StorageProfileArgs =
        com.pulumi.azurenative.networkcloud.inputs.StorageProfileArgs.builder()
            .osDisk(osDisk.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .volumeAttachments(volumeAttachments?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [StorageProfileArgs].
 */
@PulumiTagMarker
public class StorageProfileArgsBuilder internal constructor() {
    private var osDisk: Output<OsDiskArgs>? = null

    private var volumeAttachments: Output<List<String>>? = null

    /**
     * @param value The disk to use with this virtual machine.
     */
    @JvmName("prxrygkelwyjcnrf")
    public suspend fun osDisk(`value`: Output<OsDiskArgs>) {
        this.osDisk = value
    }

    /**
     * @param value The resource IDs of volumes that are requested to be attached to the virtual machine.
     */
    @JvmName("slvcoppiqqhkfxqk")
    public suspend fun volumeAttachments(`value`: Output<List<String>>) {
        this.volumeAttachments = value
    }

    @JvmName("skepfqdelkwcycqy")
    public suspend fun volumeAttachments(vararg values: Output<String>) {
        this.volumeAttachments = Output.all(values.asList())
    }

    /**
     * @param values The resource IDs of volumes that are requested to be attached to the virtual machine.
     */
    @JvmName("lbormawjyusbcrmp")
    public suspend fun volumeAttachments(values: List<Output<String>>) {
        this.volumeAttachments = Output.all(values)
    }

    /**
     * @param value The disk to use with this virtual machine.
     */
    @JvmName("hhxnxsjecsfdfset")
    public suspend fun osDisk(`value`: OsDiskArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.osDisk = mapped
    }

    /**
     * @param argument The disk to use with this virtual machine.
     */
    @JvmName("vllxohswuepflvse")
    public suspend fun osDisk(argument: suspend OsDiskArgsBuilder.() -> Unit) {
        val toBeMapped = OsDiskArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.osDisk = mapped
    }

    /**
     * @param value The resource IDs of volumes that are requested to be attached to the virtual machine.
     */
    @JvmName("frghphilfcpwlalc")
    public suspend fun volumeAttachments(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeAttachments = mapped
    }

    /**
     * @param values The resource IDs of volumes that are requested to be attached to the virtual machine.
     */
    @JvmName("vvnasqkfvxjecbch")
    public suspend fun volumeAttachments(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeAttachments = mapped
    }

    internal fun build(): StorageProfileArgs = StorageProfileArgs(
        osDisk = osDisk ?: throw PulumiNullFieldException("osDisk"),
        volumeAttachments = volumeAttachments,
    )
}
