@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property aggregatorOrSingleRackDefinition The rack definition that is intended to reflect only a single rack in a single rack cluster, or an aggregator rack in a multi-rack cluster.
 * @property analyticsWorkspaceId The resource ID of the Log Analytics Workspace that will be used for storing relevant logs.
 * @property availableUpgradeVersions The list of cluster runtime version upgrades available for this cluster.
 * @property clusterCapacity The capacity supported by this cluster.
 * @property clusterConnectionStatus The latest heartbeat status between the cluster manager and the cluster.
 * @property clusterExtendedLocation The extended location (custom location) that represents the cluster's control plane location. This extended location is used to route the requests of child objects of the cluster that are handled by the platform operator.
 * @property clusterLocation The customer-provided location information to identify where the cluster resides.
 * @property clusterManagerConnectionStatus The latest connectivity status between cluster manager and the cluster.
 * @property clusterManagerId The resource ID of the cluster manager that manages this cluster. This is set by the Cluster Manager when the cluster is created.
 * @property clusterServicePrincipal The service principal to be used by the cluster during Arc Appliance installation.
 * @property clusterType The type of rack configuration for the cluster.
 * @property clusterVersion The current runtime version of the cluster.
 * @property computeDeploymentThreshold The validation threshold indicating the allowable failures of compute machines during environment validation and deployment.
 * @property computeRackDefinitions The list of rack definitions for the compute racks in a multi-rack
 * cluster, or an empty list in a single-rack cluster.
 * @property detailedStatus The current detailed status of the cluster.
 * @property detailedStatusMessage The descriptive message about the detailed status.
 * @property extendedLocation The extended location of the cluster manager associated with the cluster.
 * @property hybridAksExtendedLocation Field Deprecated. This field will not be populated in an upcoming version. The extended location (custom location) that represents the Hybrid AKS control plane location. This extended location is used when creating provisioned clusters (Hybrid AKS clusters).
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property managedResourceGroupConfiguration The configuration of the managed resource group associated with the resource.
 * @property manualActionCount The count of Manual Action Taken (MAT) events that have not been validated.
 * @property name The name of the resource
 * @property networkFabricId The resource ID of the Network Fabric associated with the cluster.
 * @property provisioningState The provisioning state of the cluster.
 * @property supportExpiryDate The support end date of the runtime version of the cluster.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property workloadResourceIds The list of workload resource IDs that are hosted within this cluster.
 */
public data class GetClusterResult(
    public val aggregatorOrSingleRackDefinition: RackDefinitionResponse,
    public val analyticsWorkspaceId: String? = null,
    public val availableUpgradeVersions: List<ClusterAvailableUpgradeVersionResponse>,
    public val clusterCapacity: ClusterCapacityResponse,
    public val clusterConnectionStatus: String,
    public val clusterExtendedLocation: ExtendedLocationResponse,
    public val clusterLocation: String? = null,
    public val clusterManagerConnectionStatus: String,
    public val clusterManagerId: String,
    public val clusterServicePrincipal: ServicePrincipalInformationResponse? = null,
    public val clusterType: String,
    public val clusterVersion: String,
    public val computeDeploymentThreshold: ValidationThresholdResponse? = null,
    public val computeRackDefinitions: List<RackDefinitionResponse>? = null,
    public val detailedStatus: String,
    public val detailedStatusMessage: String,
    public val extendedLocation: ExtendedLocationResponse,
    public val hybridAksExtendedLocation: ExtendedLocationResponse,
    public val id: String,
    public val location: String,
    public val managedResourceGroupConfiguration: ManagedResourceGroupConfigurationResponse? = null,
    public val manualActionCount: Double,
    public val name: String,
    public val networkFabricId: String,
    public val provisioningState: String,
    public val supportExpiryDate: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val workloadResourceIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.GetClusterResult):
            GetClusterResult = GetClusterResult(
            aggregatorOrSingleRackDefinition = javaType.aggregatorOrSingleRackDefinition().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.RackDefinitionResponse.Companion.toKotlin(args0)
            }),
            analyticsWorkspaceId = javaType.analyticsWorkspaceId().map({ args0 -> args0 }).orElse(null),
            availableUpgradeVersions = javaType.availableUpgradeVersions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.ClusterAvailableUpgradeVersionResponse.Companion.toKotlin(args0)
                })
            }),
            clusterCapacity = javaType.clusterCapacity().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ClusterCapacityResponse.Companion.toKotlin(args0)
            }),
            clusterConnectionStatus = javaType.clusterConnectionStatus(),
            clusterExtendedLocation = javaType.clusterExtendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            clusterLocation = javaType.clusterLocation().map({ args0 -> args0 }).orElse(null),
            clusterManagerConnectionStatus = javaType.clusterManagerConnectionStatus(),
            clusterManagerId = javaType.clusterManagerId(),
            clusterServicePrincipal = javaType.clusterServicePrincipal().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.ServicePrincipalInformationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            clusterType = javaType.clusterType(),
            clusterVersion = javaType.clusterVersion(),
            computeDeploymentThreshold = javaType.computeDeploymentThreshold().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.ValidationThresholdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            computeRackDefinitions = javaType.computeRackDefinitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.RackDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            detailedStatus = javaType.detailedStatus(),
            detailedStatusMessage = javaType.detailedStatusMessage(),
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            hybridAksExtendedLocation = javaType.hybridAksExtendedLocation().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            managedResourceGroupConfiguration = javaType.managedResourceGroupConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkcloud.kotlin.outputs.ManagedResourceGroupConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            manualActionCount = javaType.manualActionCount(),
            name = javaType.name(),
            networkFabricId = javaType.networkFabricId(),
            provisioningState = javaType.provisioningState(),
            supportExpiryDate = javaType.supportExpiryDate(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            workloadResourceIds = javaType.workloadResourceIds().map({ args0 -> args0 }),
        )
    }
}
