@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property azureUserName The user name that will be used for access.
 * @property description The free-form description for this user.
 * @property sshPublicKey The SSH public key that will be provisioned for user access. The user is expected to have the corresponding SSH private key for logging in.
 */
public data class KeySetUserResponse(
    public val azureUserName: String,
    public val description: String? = null,
    public val sshPublicKey: SshPublicKeyResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.KeySetUserResponse):
            KeySetUserResponse = KeySetUserResponse(
            azureUserName = javaType.azureUserName(),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            sshPublicKey = javaType.sshPublicKey().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.SshPublicKeyResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
