@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property location The location of the managed resource group. If not specified, the location of the parent resource is chosen.
 * @property name The name for the managed resource group. If not specified, the unique name is automatically generated.
 */
public data class ManagedResourceGroupConfigurationResponse(
    public val location: String? = null,
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.ManagedResourceGroupConfigurationResponse):
            ManagedResourceGroupConfigurationResponse = ManagedResourceGroupConfigurationResponse(
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
