@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property createOption The strategy for creating the OS disk.
 * @property deleteOption The strategy for deleting the OS disk.
 * @property diskSizeGB The size of the disk in gigabytes. Required if the createOption is Ephemeral.
 */
public data class OsDiskResponse(
    public val createOption: String? = null,
    public val deleteOption: String? = null,
    public val diskSizeGB: Double,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.OsDiskResponse):
            OsDiskResponse = OsDiskResponse(
            createOption = javaType.createOption().map({ args0 -> args0 }).orElse(null),
            deleteOption = javaType.deleteOption().map({ args0 -> args0 }).orElse(null),
            diskSizeGB = javaType.diskSizeGB(),
        )
    }
}
