@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bfdEnabled The indicator of BFD enablement for this BgpPeer.
 * @property bgpMultiHop The indicator to enable multi-hop peering support.
 * @property holdTime The requested BGP hold time value. This field uses ISO 8601 duration format, for example P1H.
 * @property keepAliveTime The requested BGP keepalive time value. This field uses ISO 8601 duration format, for example P1H.
 * @property myAsn The autonomous system number used for the local end of the BGP session.
 * @property name The name used to identify this BGP peer for association with a BGP advertisement.
 * @property peerAddress The IPv4 or IPv6 address used to connect this BGP session.
 * @property peerAsn The autonomous system number expected from the remote end of the BGP session.
 * @property peerPort The port used to connect this BGP session.
 */
public data class ServiceLoadBalancerBgpPeerResponse(
    public val bfdEnabled: String? = null,
    public val bgpMultiHop: String? = null,
    public val holdTime: String? = null,
    public val keepAliveTime: String? = null,
    public val myAsn: Double? = null,
    public val name: String,
    public val peerAddress: String,
    public val peerAsn: Double,
    public val peerPort: Double? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.ServiceLoadBalancerBgpPeerResponse):
            ServiceLoadBalancerBgpPeerResponse = ServiceLoadBalancerBgpPeerResponse(
            bfdEnabled = javaType.bfdEnabled().map({ args0 -> args0 }).orElse(null),
            bgpMultiHop = javaType.bgpMultiHop().map({ args0 -> args0 }).orElse(null),
            holdTime = javaType.holdTime().map({ args0 -> args0 }).orElse(null),
            keepAliveTime = javaType.keepAliveTime().map({ args0 -> args0 }).orElse(null),
            myAsn = javaType.myAsn().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            peerAddress = javaType.peerAddress(),
            peerAsn = javaType.peerAsn(),
            peerPort = javaType.peerPort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
