@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkcloud.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property osDisk The disk to use with this virtual machine.
 * @property volumeAttachments The resource IDs of volumes that are requested to be attached to the virtual machine.
 */
public data class StorageProfileResponse(
    public val osDisk: OsDiskResponse,
    public val volumeAttachments: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkcloud.outputs.StorageProfileResponse):
            StorageProfileResponse = StorageProfileResponse(
            osDisk = javaType.osDisk().let({ args0 ->
                com.pulumi.azurenative.networkcloud.kotlin.outputs.OsDiskResponse.Companion.toKotlin(args0)
            }),
            volumeAttachments = javaType.volumeAttachments().map({ args0 -> args0 }),
        )
    }
}
