@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin

import com.pulumi.azurenative.networkfunction.kotlin.outputs.ResourceReferenceResponse
import com.pulumi.azurenative.networkfunction.kotlin.outputs.TrackedResourceResponseSystemData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.networkfunction.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin as resourceReferenceResponseToKotlin
import com.pulumi.azurenative.networkfunction.kotlin.outputs.TrackedResourceResponseSystemData.Companion.toKotlin as trackedResourceResponseSystemDataToKotlin

/**
 * Builder for [AzureTrafficCollector].
 */
@PulumiTagMarker
public class AzureTrafficCollectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AzureTrafficCollectorArgs = AzureTrafficCollectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AzureTrafficCollectorArgsBuilder.() -> Unit) {
        val builder = AzureTrafficCollectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AzureTrafficCollector {
        val builtJavaResource =
            com.pulumi.azurenative.networkfunction.AzureTrafficCollector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AzureTrafficCollector(builtJavaResource)
    }
}

/**
 * Azure Traffic Collector resource.
 * Azure REST API version: 2022-11-01. Prior API version in Azure Native 1.x: 2022-05-01.
 * Other available API versions: 2022-08-01.
 * ## Example Usage
 * ### Create a traffic collector
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureTrafficCollector = new AzureNative.NetworkFunction.AzureTrafficCollector("azureTrafficCollector", new()
 *     {
 *         AzureTrafficCollectorName = "atc",
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/networkfunction/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := networkfunction.NewAzureTrafficCollector(ctx, "azureTrafficCollector", &networkfunction.AzureTrafficCollectorArgs{
 * 			AzureTrafficCollectorName: pulumi.String("atc"),
 * 			Location:                  pulumi.String("West US"),
 * 			ResourceGroupName:         pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.networkfunction.AzureTrafficCollector;
 * import com.pulumi.azurenative.networkfunction.AzureTrafficCollectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureTrafficCollector = new AzureTrafficCollector("azureTrafficCollector", AzureTrafficCollectorArgs.builder()
 *             .azureTrafficCollectorName("atc")
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:networkfunction:AzureTrafficCollector atc /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkFunction/azureTrafficCollectors/{azureTrafficCollectorName}
 * ```
 */
public class AzureTrafficCollector internal constructor(
    override val javaResource: com.pulumi.azurenative.networkfunction.AzureTrafficCollector,
) : KotlinCustomResource(javaResource, AzureTrafficCollectorMapper) {
    /**
     * Collector Policies for Azure Traffic Collector.
     */
    public val collectorPolicies: Output<List<ResourceReferenceResponse>>
        get() = javaResource.collectorPolicies().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceReferenceResponseToKotlin(args0) })
            })
        })

    /**
     * A unique read-only string that changes whenever the resource is updated.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The provisioning state of the application rule collection resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<TrackedResourceResponseSystemData>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                trackedResourceResponseSystemDataToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The virtualHub to which the Azure Traffic Collector belongs.
     */
    public val virtualHub: Output<ResourceReferenceResponse>?
        get() = javaResource.virtualHub().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceReferenceResponseToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object AzureTrafficCollectorMapper : ResourceMapper<AzureTrafficCollector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.networkfunction.AzureTrafficCollector::class == javaResource::class

    override fun map(javaResource: Resource): AzureTrafficCollector =
        AzureTrafficCollector(
            javaResource as
                com.pulumi.azurenative.networkfunction.AzureTrafficCollector,
        )
}

/**
 * @see [AzureTrafficCollector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AzureTrafficCollector].
 */
public suspend fun azureTrafficCollector(
    name: String,
    block: suspend AzureTrafficCollectorResourceBuilder.() -> Unit,
): AzureTrafficCollector {
    val builder = AzureTrafficCollectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AzureTrafficCollector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun azureTrafficCollector(name: String): AzureTrafficCollector {
    val builder = AzureTrafficCollectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
