@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin.inputs

import com.pulumi.azurenative.networkfunction.inputs.EmissionPoliciesPropertiesFormatArgs.builder
import com.pulumi.azurenative.networkfunction.kotlin.enums.EmissionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Emission policy properties.
 * @property emissionDestinations Emission policy destinations.
 * @property emissionType Emission format type.
 */
public data class EmissionPoliciesPropertiesFormatArgs(
    public val emissionDestinations: Output<List<EmissionPolicyDestinationArgs>>? = null,
    public val emissionType: Output<Either<String, EmissionType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.networkfunction.inputs.EmissionPoliciesPropertiesFormatArgs> {
    override fun toJava():
        com.pulumi.azurenative.networkfunction.inputs.EmissionPoliciesPropertiesFormatArgs =
        com.pulumi.azurenative.networkfunction.inputs.EmissionPoliciesPropertiesFormatArgs.builder()
            .emissionDestinations(
                emissionDestinations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .emissionType(
                emissionType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [EmissionPoliciesPropertiesFormatArgs].
 */
@PulumiTagMarker
public class EmissionPoliciesPropertiesFormatArgsBuilder internal constructor() {
    private var emissionDestinations: Output<List<EmissionPolicyDestinationArgs>>? = null

    private var emissionType: Output<Either<String, EmissionType>>? = null

    /**
     * @param value Emission policy destinations.
     */
    @JvmName("dhvuaumccjyduagc")
    public suspend fun emissionDestinations(`value`: Output<List<EmissionPolicyDestinationArgs>>) {
        this.emissionDestinations = value
    }

    @JvmName("osbvamqrnfimtcpm")
    public suspend fun emissionDestinations(vararg values: Output<EmissionPolicyDestinationArgs>) {
        this.emissionDestinations = Output.all(values.asList())
    }

    /**
     * @param values Emission policy destinations.
     */
    @JvmName("ohjvpoaeuaprklag")
    public suspend fun emissionDestinations(values: List<Output<EmissionPolicyDestinationArgs>>) {
        this.emissionDestinations = Output.all(values)
    }

    /**
     * @param value Emission format type.
     */
    @JvmName("teoxkdiylmjmedml")
    public suspend fun emissionType(`value`: Output<Either<String, EmissionType>>) {
        this.emissionType = value
    }

    /**
     * @param value Emission policy destinations.
     */
    @JvmName("pcweieqavrnlueks")
    public suspend fun emissionDestinations(`value`: List<EmissionPolicyDestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emissionDestinations = mapped
    }

    /**
     * @param argument Emission policy destinations.
     */
    @JvmName("kjuwymwdloyqqmhg")
    public suspend
    fun emissionDestinations(argument: List<suspend EmissionPolicyDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EmissionPolicyDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.emissionDestinations = mapped
    }

    /**
     * @param argument Emission policy destinations.
     */
    @JvmName("seadfyewqcjxiyeu")
    public suspend fun emissionDestinations(
        vararg
        argument: suspend EmissionPolicyDestinationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            EmissionPolicyDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.emissionDestinations = mapped
    }

    /**
     * @param argument Emission policy destinations.
     */
    @JvmName("wvgpudlskeklkdlo")
    public suspend
    fun emissionDestinations(argument: suspend EmissionPolicyDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EmissionPolicyDestinationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.emissionDestinations = mapped
    }

    /**
     * @param values Emission policy destinations.
     */
    @JvmName("qdpccxpakmytjioo")
    public suspend fun emissionDestinations(vararg values: EmissionPolicyDestinationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emissionDestinations = mapped
    }

    /**
     * @param value Emission format type.
     */
    @JvmName("kpkeprmsumhqdorw")
    public suspend fun emissionType(`value`: Either<String, EmissionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emissionType = mapped
    }

    /**
     * @param value Emission format type.
     */
    @JvmName("exggdcysbnlqjbxs")
    public fun emissionType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EmissionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emissionType = mapped
    }

    /**
     * @param value Emission format type.
     */
    @JvmName("ebbqkqfpgrmeqbmd")
    public fun emissionType(`value`: EmissionType) {
        val toBeMapped = Either.ofRight<String, EmissionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.emissionType = mapped
    }

    internal fun build(): EmissionPoliciesPropertiesFormatArgs = EmissionPoliciesPropertiesFormatArgs(
        emissionDestinations = emissionDestinations,
        emissionType = emissionType,
    )
}
