@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin.inputs

import com.pulumi.azurenative.networkfunction.inputs.GetAzureTrafficCollectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property azureTrafficCollectorName Azure Traffic Collector name
 * @property resourceGroupName The name of the resource group.
 */
public data class GetAzureTrafficCollectorPlainArgs(
    public val azureTrafficCollectorName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.networkfunction.inputs.GetAzureTrafficCollectorPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.networkfunction.inputs.GetAzureTrafficCollectorPlainArgs =
        com.pulumi.azurenative.networkfunction.inputs.GetAzureTrafficCollectorPlainArgs.builder()
            .azureTrafficCollectorName(azureTrafficCollectorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAzureTrafficCollectorPlainArgs].
 */
@PulumiTagMarker
public class GetAzureTrafficCollectorPlainArgsBuilder internal constructor() {
    private var azureTrafficCollectorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Azure Traffic Collector name
     */
    @JvmName("ubmiraplogctqqkk")
    public suspend fun azureTrafficCollectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.azureTrafficCollectorName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ufmumfrfyedvpwvp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAzureTrafficCollectorPlainArgs = GetAzureTrafficCollectorPlainArgs(
        azureTrafficCollectorName = azureTrafficCollectorName ?: throw
            PulumiNullFieldException("azureTrafficCollectorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
