@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Emission policy properties.
 * @property emissionDestinations Emission policy destinations.
 * @property emissionType Emission format type.
 */
public data class EmissionPoliciesPropertiesFormatResponse(
    public val emissionDestinations: List<EmissionPolicyDestinationResponse>? = null,
    public val emissionType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkfunction.outputs.EmissionPoliciesPropertiesFormatResponse):
            EmissionPoliciesPropertiesFormatResponse = EmissionPoliciesPropertiesFormatResponse(
            emissionDestinations = javaType.emissionDestinations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkfunction.kotlin.outputs.EmissionPolicyDestinationResponse.Companion.toKotlin(args0)
                })
            }),
            emissionType = javaType.emissionType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
