@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.networkfunction.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Azure Traffic Collector resource.
 * @property collectorPolicies Collector Policies for Azure Traffic Collector.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the application rule collection resource.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualHub The virtualHub to which the Azure Traffic Collector belongs.
 */
public data class GetAzureTrafficCollectorResult(
    public val collectorPolicies: List<ResourceReferenceResponse>,
    public val etag: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: TrackedResourceResponseSystemData,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualHub: ResourceReferenceResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.networkfunction.outputs.GetAzureTrafficCollectorResult):
            GetAzureTrafficCollectorResult = GetAzureTrafficCollectorResult(
            collectorPolicies = javaType.collectorPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkfunction.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.networkfunction.kotlin.outputs.TrackedResourceResponseSystemData.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualHub = javaType.virtualHub().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.networkfunction.kotlin.outputs.ResourceReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
