@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin

import com.pulumi.azurenative.notificationhubs.kotlin.outputs.NotificationHubPropertiesResponse
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.NotificationHubPropertiesResponse.Companion.toKotlin as notificationHubPropertiesResponseToKotlin
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NotificationHub].
 */
@PulumiTagMarker
public class NotificationHubResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NotificationHubArgs = NotificationHubArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NotificationHubArgsBuilder.() -> Unit) {
        val builder = NotificationHubArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): NotificationHub {
        val builtJavaResource =
            com.pulumi.azurenative.notificationhubs.NotificationHub(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NotificationHub(builtJavaResource)
    }
}

/**
 * Notification Hub Resource.
 * Azure REST API version: 2023-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2014-09-01, 2016-03-01, 2017-04-01, 2023-09-01, 2023-10-01-preview.
 * ## Example Usage
 * ### NotificationHubs_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var notificationHub = new AzureNative.NotificationHubs.NotificationHub("notificationHub", new()
 *     {
 *         Location = "eastus",
 *         NamespaceName = "nh-sdk-ns",
 *         NotificationHubName = "nh-sdk-hub",
 *         Properties = null,
 *         ResourceGroupName = "5ktrial",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/notificationhubs/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := notificationhubs.NewNotificationHub(ctx, "notificationHub", &notificationhubs.NotificationHubArgs{
 * 			Location:            pulumi.String("eastus"),
 * 			NamespaceName:       pulumi.String("nh-sdk-ns"),
 * 			NotificationHubName: pulumi.String("nh-sdk-hub"),
 * 			Properties:          nil,
 * 			ResourceGroupName:   pulumi.String("5ktrial"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.notificationhubs.NotificationHub;
 * import com.pulumi.azurenative.notificationhubs.NotificationHubArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var notificationHub = new NotificationHub("notificationHub", NotificationHubArgs.builder()
 *             .location("eastus")
 *             .namespaceName("nh-sdk-ns")
 *             .notificationHubName("nh-sdk-hub")
 *             .properties()
 *             .resourceGroupName("5ktrial")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:notificationhubs:NotificationHub test /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/notificationHubs/{notificationHubName}
 * ```
 */
public class NotificationHub internal constructor(
    override val javaResource: com.pulumi.azurenative.notificationhubs.NotificationHub,
) : KotlinCustomResource(javaResource, NotificationHubMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * NotificationHub properties.
     */
    public val properties: Output<NotificationHubPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                notificationHubPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * The Sku description for a namespace
     */
    public val sku: Output<SkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    skuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object NotificationHubMapper : ResourceMapper<NotificationHub> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.notificationhubs.NotificationHub::class == javaResource::class

    override fun map(javaResource: Resource): NotificationHub = NotificationHub(
        javaResource as
            com.pulumi.azurenative.notificationhubs.NotificationHub,
    )
}

/**
 * @see [NotificationHub].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NotificationHub].
 */
public suspend fun notificationHub(
    name: String,
    block: suspend NotificationHubResourceBuilder.() -> Unit,
): NotificationHub {
    val builder = NotificationHubResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NotificationHub].
 * @param name The _unique_ name of the resulting resource.
 */
public fun notificationHub(name: String): NotificationHub {
    val builder = NotificationHubResourceBuilder()
    builder.name(name)
    return builder.build()
}
