@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin

import com.pulumi.azurenative.notificationhubs.NotificationhubsFunctions.getNamespaceAuthorizationRulePlain
import com.pulumi.azurenative.notificationhubs.NotificationhubsFunctions.getNamespacePlain
import com.pulumi.azurenative.notificationhubs.NotificationhubsFunctions.getNamespacePnsCredentialsPlain
import com.pulumi.azurenative.notificationhubs.NotificationhubsFunctions.getNotificationHubAuthorizationRulePlain
import com.pulumi.azurenative.notificationhubs.NotificationhubsFunctions.getNotificationHubPlain
import com.pulumi.azurenative.notificationhubs.NotificationhubsFunctions.getNotificationHubPnsCredentialsPlain
import com.pulumi.azurenative.notificationhubs.NotificationhubsFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.notificationhubs.NotificationhubsFunctions.listNamespaceKeysPlain
import com.pulumi.azurenative.notificationhubs.NotificationhubsFunctions.listNotificationHubKeysPlain
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.GetNamespaceAuthorizationRulePlainArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.GetNamespaceAuthorizationRulePlainArgsBuilder
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.GetNamespacePlainArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.GetNamespacePlainArgsBuilder
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.GetNamespacePnsCredentialsPlainArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.GetNamespacePnsCredentialsPlainArgsBuilder
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.GetNotificationHubAuthorizationRulePlainArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.GetNotificationHubAuthorizationRulePlainArgsBuilder
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.GetNotificationHubPlainArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.GetNotificationHubPlainArgsBuilder
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.GetNotificationHubPnsCredentialsPlainArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.GetNotificationHubPnsCredentialsPlainArgsBuilder
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.ListNamespaceKeysPlainArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.ListNamespaceKeysPlainArgsBuilder
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.ListNotificationHubKeysPlainArgs
import com.pulumi.azurenative.notificationhubs.kotlin.inputs.ListNotificationHubKeysPlainArgsBuilder
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.GetNamespaceAuthorizationRuleResult
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.GetNamespacePnsCredentialsResult
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.GetNamespaceResult
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.GetNotificationHubAuthorizationRuleResult
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.GetNotificationHubPnsCredentialsResult
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.GetNotificationHubResult
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.ListNamespaceKeysResult
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.ListNotificationHubKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.GetNamespaceAuthorizationRuleResult.Companion.toKotlin as getNamespaceAuthorizationRuleResultToKotlin
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.GetNamespacePnsCredentialsResult.Companion.toKotlin as getNamespacePnsCredentialsResultToKotlin
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.GetNamespaceResult.Companion.toKotlin as getNamespaceResultToKotlin
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.GetNotificationHubAuthorizationRuleResult.Companion.toKotlin as getNotificationHubAuthorizationRuleResultToKotlin
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.GetNotificationHubPnsCredentialsResult.Companion.toKotlin as getNotificationHubPnsCredentialsResultToKotlin
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.GetNotificationHubResult.Companion.toKotlin as getNotificationHubResultToKotlin
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.ListNamespaceKeysResult.Companion.toKotlin as listNamespaceKeysResultToKotlin
import com.pulumi.azurenative.notificationhubs.kotlin.outputs.ListNotificationHubKeysResult.Companion.toKotlin as listNotificationHubKeysResultToKotlin

public object NotificationhubsFunctions {
    /**
     * Notification Hubs Namespace Resource.
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2014-09-01, 2016-03-01, 2017-04-01, 2023-09-01, 2023-10-01-preview.
     * @param argument null
     * @return Notification Hubs Namespace Resource.
     */
    public suspend fun getNamespace(argument: GetNamespacePlainArgs): GetNamespaceResult =
        getNamespaceResultToKotlin(getNamespacePlain(argument.toJava()).await())

    /**
     * @see [getNamespace].
     * @param namespaceName Namespace name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Notification Hubs Namespace Resource.
     */
    public suspend fun getNamespace(namespaceName: String, resourceGroupName: String):
        GetNamespaceResult {
        val argument = GetNamespacePlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNamespaceResultToKotlin(getNamespacePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;notificationhubs&#46;kotlin&#46;inputs&#46;GetNamespacePlainArgs].
     * @return Notification Hubs Namespace Resource.
     */
    public suspend fun getNamespace(argument: suspend GetNamespacePlainArgsBuilder.() -> Unit):
        GetNamespaceResult {
        val builder = GetNamespacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceResultToKotlin(getNamespacePlain(builtArgument.toJava()).await())
    }

    /**
     * Response for POST requests that return single SharedAccessAuthorizationRule.
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2016-03-01, 2017-04-01, 2023-09-01, 2023-10-01-preview.
     * @param argument null
     * @return Response for POST requests that return single SharedAccessAuthorizationRule.
     */
    public suspend
    fun getNamespaceAuthorizationRule(argument: GetNamespaceAuthorizationRulePlainArgs):
        GetNamespaceAuthorizationRuleResult =
        getNamespaceAuthorizationRuleResultToKotlin(getNamespaceAuthorizationRulePlain(argument.toJava()).await())

    /**
     * @see [getNamespaceAuthorizationRule].
     * @param authorizationRuleName Authorization Rule Name
     * @param namespaceName Namespace name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response for POST requests that return single SharedAccessAuthorizationRule.
     */
    public suspend fun getNamespaceAuthorizationRule(
        authorizationRuleName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): GetNamespaceAuthorizationRuleResult {
        val argument = GetNamespaceAuthorizationRulePlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNamespaceAuthorizationRuleResultToKotlin(getNamespaceAuthorizationRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespaceAuthorizationRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;notificationhubs&#46;kotlin&#46;inputs&#46;GetNamespaceAuthorizationRulePlainArgs].
     * @return Response for POST requests that return single SharedAccessAuthorizationRule.
     */
    public suspend
    fun getNamespaceAuthorizationRule(argument: suspend GetNamespaceAuthorizationRulePlainArgsBuilder.() -> Unit):
        GetNamespaceAuthorizationRuleResult {
        val builder = GetNamespaceAuthorizationRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespaceAuthorizationRuleResultToKotlin(getNamespaceAuthorizationRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Description of a NotificationHub PNS Credentials. This is a response of the POST requests that return namespace or hubs
     * PNS credentials.
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2023-09-01, 2023-10-01-preview.
     * @param argument null
     * @return Description of a NotificationHub PNS Credentials. This is a response of the POST requests that return namespace or hubs
     * PNS credentials.
     */
    public suspend fun getNamespacePnsCredentials(argument: GetNamespacePnsCredentialsPlainArgs):
        GetNamespacePnsCredentialsResult =
        getNamespacePnsCredentialsResultToKotlin(getNamespacePnsCredentialsPlain(argument.toJava()).await())

    /**
     * @see [getNamespacePnsCredentials].
     * @param namespaceName Namespace name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Description of a NotificationHub PNS Credentials. This is a response of the POST requests that return namespace or hubs
     * PNS credentials.
     */
    public suspend fun getNamespacePnsCredentials(namespaceName: String, resourceGroupName: String):
        GetNamespacePnsCredentialsResult {
        val argument = GetNamespacePnsCredentialsPlainArgs(
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return getNamespacePnsCredentialsResultToKotlin(getNamespacePnsCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [getNamespacePnsCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;notificationhubs&#46;kotlin&#46;inputs&#46;GetNamespacePnsCredentialsPlainArgs].
     * @return Description of a NotificationHub PNS Credentials. This is a response of the POST requests that return namespace or hubs
     * PNS credentials.
     */
    public suspend
    fun getNamespacePnsCredentials(argument: suspend GetNamespacePnsCredentialsPlainArgsBuilder.() -> Unit):
        GetNamespacePnsCredentialsResult {
        val builder = GetNamespacePnsCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNamespacePnsCredentialsResultToKotlin(getNamespacePnsCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * Notification Hub Resource.
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2014-09-01, 2016-03-01, 2017-04-01, 2023-09-01, 2023-10-01-preview.
     * @param argument null
     * @return Notification Hub Resource.
     */
    public suspend fun getNotificationHub(argument: GetNotificationHubPlainArgs):
        GetNotificationHubResult =
        getNotificationHubResultToKotlin(getNotificationHubPlain(argument.toJava()).await())

    /**
     * @see [getNotificationHub].
     * @param namespaceName Namespace name
     * @param notificationHubName Notification Hub name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Notification Hub Resource.
     */
    public suspend fun getNotificationHub(
        namespaceName: String,
        notificationHubName: String,
        resourceGroupName: String,
    ): GetNotificationHubResult {
        val argument = GetNotificationHubPlainArgs(
            namespaceName = namespaceName,
            notificationHubName = notificationHubName,
            resourceGroupName = resourceGroupName,
        )
        return getNotificationHubResultToKotlin(getNotificationHubPlain(argument.toJava()).await())
    }

    /**
     * @see [getNotificationHub].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;notificationhubs&#46;kotlin&#46;inputs&#46;GetNotificationHubPlainArgs].
     * @return Notification Hub Resource.
     */
    public suspend
    fun getNotificationHub(argument: suspend GetNotificationHubPlainArgsBuilder.() -> Unit):
        GetNotificationHubResult {
        val builder = GetNotificationHubPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNotificationHubResultToKotlin(getNotificationHubPlain(builtArgument.toJava()).await())
    }

    /**
     * Response for POST requests that return single SharedAccessAuthorizationRule.
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2016-03-01, 2017-04-01, 2023-09-01, 2023-10-01-preview.
     * @param argument null
     * @return Response for POST requests that return single SharedAccessAuthorizationRule.
     */
    public suspend
    fun getNotificationHubAuthorizationRule(argument: GetNotificationHubAuthorizationRulePlainArgs):
        GetNotificationHubAuthorizationRuleResult =
        getNotificationHubAuthorizationRuleResultToKotlin(getNotificationHubAuthorizationRulePlain(argument.toJava()).await())

    /**
     * @see [getNotificationHubAuthorizationRule].
     * @param authorizationRuleName Authorization Rule Name
     * @param namespaceName Namespace name
     * @param notificationHubName Notification Hub name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response for POST requests that return single SharedAccessAuthorizationRule.
     */
    public suspend fun getNotificationHubAuthorizationRule(
        authorizationRuleName: String,
        namespaceName: String,
        notificationHubName: String,
        resourceGroupName: String,
    ): GetNotificationHubAuthorizationRuleResult {
        val argument = GetNotificationHubAuthorizationRulePlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            notificationHubName = notificationHubName,
            resourceGroupName = resourceGroupName,
        )
        return getNotificationHubAuthorizationRuleResultToKotlin(getNotificationHubAuthorizationRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getNotificationHubAuthorizationRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;notificationhubs&#46;kotlin&#46;inputs&#46;GetNotificationHubAuthorizationRulePlainArgs].
     * @return Response for POST requests that return single SharedAccessAuthorizationRule.
     */
    public suspend
    fun getNotificationHubAuthorizationRule(argument: suspend GetNotificationHubAuthorizationRulePlainArgsBuilder.() -> Unit):
        GetNotificationHubAuthorizationRuleResult {
        val builder = GetNotificationHubAuthorizationRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNotificationHubAuthorizationRuleResultToKotlin(getNotificationHubAuthorizationRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Description of a NotificationHub PNS Credentials. This is a response of the POST requests that return namespace or hubs
     * PNS credentials.
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2014-09-01, 2016-03-01, 2017-04-01, 2023-09-01, 2023-10-01-preview.
     * @param argument null
     * @return Description of a NotificationHub PNS Credentials. This is a response of the POST requests that return namespace or hubs
     * PNS credentials.
     */
    public suspend
    fun getNotificationHubPnsCredentials(argument: GetNotificationHubPnsCredentialsPlainArgs):
        GetNotificationHubPnsCredentialsResult =
        getNotificationHubPnsCredentialsResultToKotlin(getNotificationHubPnsCredentialsPlain(argument.toJava()).await())

    /**
     * @see [getNotificationHubPnsCredentials].
     * @param namespaceName Namespace name
     * @param notificationHubName Notification Hub name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Description of a NotificationHub PNS Credentials. This is a response of the POST requests that return namespace or hubs
     * PNS credentials.
     */
    public suspend fun getNotificationHubPnsCredentials(
        namespaceName: String,
        notificationHubName: String,
        resourceGroupName: String,
    ): GetNotificationHubPnsCredentialsResult {
        val argument = GetNotificationHubPnsCredentialsPlainArgs(
            namespaceName = namespaceName,
            notificationHubName = notificationHubName,
            resourceGroupName = resourceGroupName,
        )
        return getNotificationHubPnsCredentialsResultToKotlin(getNotificationHubPnsCredentialsPlain(argument.toJava()).await())
    }

    /**
     * @see [getNotificationHubPnsCredentials].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;notificationhubs&#46;kotlin&#46;inputs&#46;GetNotificationHubPnsCredentialsPlainArgs].
     * @return Description of a NotificationHub PNS Credentials. This is a response of the POST requests that return namespace or hubs
     * PNS credentials.
     */
    public suspend
    fun getNotificationHubPnsCredentials(argument: suspend GetNotificationHubPnsCredentialsPlainArgsBuilder.() -> Unit):
        GetNotificationHubPnsCredentialsResult {
        val builder = GetNotificationHubPnsCredentialsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNotificationHubPnsCredentialsResultToKotlin(getNotificationHubPnsCredentialsPlain(builtArgument.toJava()).await())
    }

    /**
     * Represents a Private Endpoint Connection ARM resource - a sub-resource of Notification Hubs namespace.
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2023-09-01, 2023-10-01-preview.
     * @param argument null
     * @return Represents a Private Endpoint Connection ARM resource - a sub-resource of Notification Hubs namespace.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param namespaceName Namespace name
     * @param privateEndpointConnectionName Private Endpoint Connection Name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Represents a Private Endpoint Connection ARM resource - a sub-resource of Notification Hubs namespace.
     */
    public suspend fun getPrivateEndpointConnection(
        namespaceName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            namespaceName = namespaceName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;notificationhubs&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return Represents a Private Endpoint Connection ARM resource - a sub-resource of Notification Hubs namespace.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Response for the POST request that returns Namespace or NotificationHub access keys (connection strings).
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2014-09-01, 2016-03-01, 2017-04-01, 2023-09-01, 2023-10-01-preview.
     * @param argument null
     * @return Response for the POST request that returns Namespace or NotificationHub access keys (connection strings).
     */
    public suspend fun listNamespaceKeys(argument: ListNamespaceKeysPlainArgs):
        ListNamespaceKeysResult =
        listNamespaceKeysResultToKotlin(listNamespaceKeysPlain(argument.toJava()).await())

    /**
     * @see [listNamespaceKeys].
     * @param authorizationRuleName Authorization Rule Name
     * @param namespaceName Namespace name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response for the POST request that returns Namespace or NotificationHub access keys (connection strings).
     */
    public suspend fun listNamespaceKeys(
        authorizationRuleName: String,
        namespaceName: String,
        resourceGroupName: String,
    ): ListNamespaceKeysResult {
        val argument = ListNamespaceKeysPlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            resourceGroupName = resourceGroupName,
        )
        return listNamespaceKeysResultToKotlin(listNamespaceKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listNamespaceKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;notificationhubs&#46;kotlin&#46;inputs&#46;ListNamespaceKeysPlainArgs].
     * @return Response for the POST request that returns Namespace or NotificationHub access keys (connection strings).
     */
    public suspend
    fun listNamespaceKeys(argument: suspend ListNamespaceKeysPlainArgsBuilder.() -> Unit):
        ListNamespaceKeysResult {
        val builder = ListNamespaceKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listNamespaceKeysResultToKotlin(listNamespaceKeysPlain(builtArgument.toJava()).await())
    }

    /**
     * Response for the POST request that returns Namespace or NotificationHub access keys (connection strings).
     * Azure REST API version: 2023-01-01-preview.
     * Other available API versions: 2014-09-01, 2016-03-01, 2017-04-01, 2023-09-01, 2023-10-01-preview.
     * @param argument null
     * @return Response for the POST request that returns Namespace or NotificationHub access keys (connection strings).
     */
    public suspend fun listNotificationHubKeys(argument: ListNotificationHubKeysPlainArgs):
        ListNotificationHubKeysResult =
        listNotificationHubKeysResultToKotlin(listNotificationHubKeysPlain(argument.toJava()).await())

    /**
     * @see [listNotificationHubKeys].
     * @param authorizationRuleName Authorization Rule Name
     * @param namespaceName Namespace name
     * @param notificationHubName Notification Hub name
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Response for the POST request that returns Namespace or NotificationHub access keys (connection strings).
     */
    public suspend fun listNotificationHubKeys(
        authorizationRuleName: String,
        namespaceName: String,
        notificationHubName: String,
        resourceGroupName: String,
    ): ListNotificationHubKeysResult {
        val argument = ListNotificationHubKeysPlainArgs(
            authorizationRuleName = authorizationRuleName,
            namespaceName = namespaceName,
            notificationHubName = notificationHubName,
            resourceGroupName = resourceGroupName,
        )
        return listNotificationHubKeysResultToKotlin(listNotificationHubKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listNotificationHubKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;notificationhubs&#46;kotlin&#46;inputs&#46;ListNotificationHubKeysPlainArgs].
     * @return Response for the POST request that returns Namespace or NotificationHub access keys (connection strings).
     */
    public suspend
    fun listNotificationHubKeys(argument: suspend ListNotificationHubKeysPlainArgsBuilder.() -> Unit):
        ListNotificationHubKeysResult {
        val builder = ListNotificationHubKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listNotificationHubKeysResultToKotlin(listNotificationHubKeysPlain(builtArgument.toJava()).await())
    }
}
