@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.ApnsCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub ApnsCredential.
 * @property properties Description of a NotificationHub ApnsCredential.
 */
public data class ApnsCredentialArgs(
    public val properties: Output<ApnsCredentialPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.ApnsCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.ApnsCredentialArgs =
        com.pulumi.azurenative.notificationhubs.inputs.ApnsCredentialArgs.builder()
            .properties(properties.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ApnsCredentialArgs].
 */
@PulumiTagMarker
public class ApnsCredentialArgsBuilder internal constructor() {
    private var properties: Output<ApnsCredentialPropertiesArgs>? = null

    /**
     * @param value Description of a NotificationHub ApnsCredential.
     */
    @JvmName("bscpgahrpxeoklnj")
    public suspend fun properties(`value`: Output<ApnsCredentialPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Description of a NotificationHub ApnsCredential.
     */
    @JvmName("cbguouahshyngjfy")
    public suspend fun properties(`value`: ApnsCredentialPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Description of a NotificationHub ApnsCredential.
     */
    @JvmName("apdoquljvcmomgto")
    public suspend fun properties(argument: suspend ApnsCredentialPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = ApnsCredentialPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): ApnsCredentialArgs = ApnsCredentialArgs(
        properties = properties ?: throw PulumiNullFieldException("properties"),
    )
}
