@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.BaiduCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub BaiduCredential.
 * @property properties Description of a NotificationHub BaiduCredential.
 */
public data class BaiduCredentialArgs(
    public val properties: Output<BaiduCredentialPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.BaiduCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.BaiduCredentialArgs =
        com.pulumi.azurenative.notificationhubs.inputs.BaiduCredentialArgs.builder()
            .properties(properties.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BaiduCredentialArgs].
 */
@PulumiTagMarker
public class BaiduCredentialArgsBuilder internal constructor() {
    private var properties: Output<BaiduCredentialPropertiesArgs>? = null

    /**
     * @param value Description of a NotificationHub BaiduCredential.
     */
    @JvmName("fmcqnxrcxwlqibcw")
    public suspend fun properties(`value`: Output<BaiduCredentialPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Description of a NotificationHub BaiduCredential.
     */
    @JvmName("uhuoopvtquejaana")
    public suspend fun properties(`value`: BaiduCredentialPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Description of a NotificationHub BaiduCredential.
     */
    @JvmName("wcdwhmdffkdrxgtl")
    public suspend fun properties(argument: suspend BaiduCredentialPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = BaiduCredentialPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): BaiduCredentialArgs = BaiduCredentialArgs(
        properties = properties ?: throw PulumiNullFieldException("properties"),
    )
}
