@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.GcmCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Description of a NotificationHub GcmCredential.
 * @property properties Description of a NotificationHub GcmCredential.
 */
public data class GcmCredentialArgs(
    public val properties: Output<GcmCredentialPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.GcmCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.GcmCredentialArgs =
        com.pulumi.azurenative.notificationhubs.inputs.GcmCredentialArgs.builder()
            .properties(properties.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GcmCredentialArgs].
 */
@PulumiTagMarker
public class GcmCredentialArgsBuilder internal constructor() {
    private var properties: Output<GcmCredentialPropertiesArgs>? = null

    /**
     * @param value Description of a NotificationHub GcmCredential.
     */
    @JvmName("wlfqbshoeonmeccs")
    public suspend fun properties(`value`: Output<GcmCredentialPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value Description of a NotificationHub GcmCredential.
     */
    @JvmName("hkimypwjqpqspmmn")
    public suspend fun properties(`value`: GcmCredentialPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Description of a NotificationHub GcmCredential.
     */
    @JvmName("bxhqycqgixycxhyg")
    public suspend fun properties(argument: suspend GcmCredentialPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = GcmCredentialPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    internal fun build(): GcmCredentialArgs = GcmCredentialArgs(
        properties = properties ?: throw PulumiNullFieldException("properties"),
    )
}
