@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.NamespacePropertiesArgs.builder
import com.pulumi.azurenative.notificationhubs.kotlin.enums.NamespaceStatus
import com.pulumi.azurenative.notificationhubs.kotlin.enums.NamespaceType
import com.pulumi.azurenative.notificationhubs.kotlin.enums.OperationProvisioningState
import com.pulumi.azurenative.notificationhubs.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.notificationhubs.kotlin.enums.ReplicationRegion
import com.pulumi.azurenative.notificationhubs.kotlin.enums.ZoneRedundancyPreference
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Represents namespace properties.
 * @property dataCenter Deprecated.
 * @property namespaceType Defines values for NamespaceType.
 * @property networkAcls A collection of network authorization rules.
 * @property pnsCredentials Collection of Notification Hub or Notification Hub Namespace PNS credentials.
 * @property provisioningState Defines values for OperationProvisioningState.
 * @property publicNetworkAccess Type of public network access.
 * @property replicationRegion Allowed replication region
 * @property scaleUnit Gets or sets scaleUnit where the namespace gets created
 * @property status Namespace status.
 * @property zoneRedundancy Namespace SKU name.
 */
public data class NamespacePropertiesArgs(
    public val dataCenter: Output<String>? = null,
    public val namespaceType: Output<Either<String, NamespaceType>>? = null,
    public val networkAcls: Output<NetworkAclsArgs>? = null,
    public val pnsCredentials: Output<PnsCredentialsArgs>? = null,
    public val provisioningState: Output<Either<String, OperationProvisioningState>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val replicationRegion: Output<Either<String, ReplicationRegion>>? = null,
    public val scaleUnit: Output<String>? = null,
    public val status: Output<Either<String, NamespaceStatus>>? = null,
    public val zoneRedundancy: Output<Either<String, ZoneRedundancyPreference>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.NamespacePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.NamespacePropertiesArgs =
        com.pulumi.azurenative.notificationhubs.inputs.NamespacePropertiesArgs.builder()
            .dataCenter(dataCenter?.applyValue({ args0 -> args0 }))
            .namespaceType(
                namespaceType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkAcls(networkAcls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .pnsCredentials(pnsCredentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .replicationRegion(
                replicationRegion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .scaleUnit(scaleUnit?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .zoneRedundancy(
                zoneRedundancy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NamespacePropertiesArgs].
 */
@PulumiTagMarker
public class NamespacePropertiesArgsBuilder internal constructor() {
    private var dataCenter: Output<String>? = null

    private var namespaceType: Output<Either<String, NamespaceType>>? = null

    private var networkAcls: Output<NetworkAclsArgs>? = null

    private var pnsCredentials: Output<PnsCredentialsArgs>? = null

    private var provisioningState: Output<Either<String, OperationProvisioningState>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var replicationRegion: Output<Either<String, ReplicationRegion>>? = null

    private var scaleUnit: Output<String>? = null

    private var status: Output<Either<String, NamespaceStatus>>? = null

    private var zoneRedundancy: Output<Either<String, ZoneRedundancyPreference>>? = null

    /**
     * @param value Deprecated.
     */
    @JvmName("idesvwymcgukorxl")
    public suspend fun dataCenter(`value`: Output<String>) {
        this.dataCenter = value
    }

    /**
     * @param value Defines values for NamespaceType.
     */
    @JvmName("rtjfnhbgtbdywjaa")
    public suspend fun namespaceType(`value`: Output<Either<String, NamespaceType>>) {
        this.namespaceType = value
    }

    /**
     * @param value A collection of network authorization rules.
     */
    @JvmName("gmctyhnnrletxljp")
    public suspend fun networkAcls(`value`: Output<NetworkAclsArgs>) {
        this.networkAcls = value
    }

    /**
     * @param value Collection of Notification Hub or Notification Hub Namespace PNS credentials.
     */
    @JvmName("auyihcsneeciihxt")
    public suspend fun pnsCredentials(`value`: Output<PnsCredentialsArgs>) {
        this.pnsCredentials = value
    }

    /**
     * @param value Defines values for OperationProvisioningState.
     */
    @JvmName("bokacjaqdyfadpjt")
    public suspend
    fun provisioningState(`value`: Output<Either<String, OperationProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value Type of public network access.
     */
    @JvmName("aopvsrywcjgfhvsm")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Allowed replication region
     */
    @JvmName("reajdgidyhwogdtf")
    public suspend fun replicationRegion(`value`: Output<Either<String, ReplicationRegion>>) {
        this.replicationRegion = value
    }

    /**
     * @param value Gets or sets scaleUnit where the namespace gets created
     */
    @JvmName("pudhjdmpaghhqlpd")
    public suspend fun scaleUnit(`value`: Output<String>) {
        this.scaleUnit = value
    }

    /**
     * @param value Namespace status.
     */
    @JvmName("fdnweksivrdhptau")
    public suspend fun status(`value`: Output<Either<String, NamespaceStatus>>) {
        this.status = value
    }

    /**
     * @param value Namespace SKU name.
     */
    @JvmName("csuqlxgqnioppcva")
    public suspend fun zoneRedundancy(`value`: Output<Either<String, ZoneRedundancyPreference>>) {
        this.zoneRedundancy = value
    }

    /**
     * @param value Deprecated.
     */
    @JvmName("pexjcormhobrhsck")
    public suspend fun dataCenter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCenter = mapped
    }

    /**
     * @param value Defines values for NamespaceType.
     */
    @JvmName("elfohxksplbpajtx")
    public suspend fun namespaceType(`value`: Either<String, NamespaceType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceType = mapped
    }

    /**
     * @param value Defines values for NamespaceType.
     */
    @JvmName("deqgbsehcaadkqqe")
    public fun namespaceType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NamespaceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespaceType = mapped
    }

    /**
     * @param value Defines values for NamespaceType.
     */
    @JvmName("fhmikgydkgnrpisl")
    public fun namespaceType(`value`: NamespaceType) {
        val toBeMapped = Either.ofRight<String, NamespaceType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespaceType = mapped
    }

    /**
     * @param value A collection of network authorization rules.
     */
    @JvmName("upqancbmbrignbxm")
    public suspend fun networkAcls(`value`: NetworkAclsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAcls = mapped
    }

    /**
     * @param argument A collection of network authorization rules.
     */
    @JvmName("ltppvakjqcqybfsr")
    public suspend fun networkAcls(argument: suspend NetworkAclsArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkAclsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkAcls = mapped
    }

    /**
     * @param value Collection of Notification Hub or Notification Hub Namespace PNS credentials.
     */
    @JvmName("ddcrvlnfwknlycjl")
    public suspend fun pnsCredentials(`value`: PnsCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pnsCredentials = mapped
    }

    /**
     * @param argument Collection of Notification Hub or Notification Hub Namespace PNS credentials.
     */
    @JvmName("oplxocgiswtnsahk")
    public suspend fun pnsCredentials(argument: suspend PnsCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = PnsCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.pnsCredentials = mapped
    }

    /**
     * @param value Defines values for OperationProvisioningState.
     */
    @JvmName("cffatmpvfovnknlk")
    public suspend fun provisioningState(`value`: Either<String, OperationProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Defines values for OperationProvisioningState.
     */
    @JvmName("bvftpxspkgwufhyx")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OperationProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Defines values for OperationProvisioningState.
     */
    @JvmName("euonfhaxdnigwtcd")
    public fun provisioningState(`value`: OperationProvisioningState) {
        val toBeMapped = Either.ofRight<String, OperationProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Type of public network access.
     */
    @JvmName("vebflgsaugayidyk")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Type of public network access.
     */
    @JvmName("jdxjugvxhyksiyaf")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Type of public network access.
     */
    @JvmName("dgmyptoexyugyyhx")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Allowed replication region
     */
    @JvmName("uqcbpnbvfbmrecvc")
    public suspend fun replicationRegion(`value`: Either<String, ReplicationRegion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationRegion = mapped
    }

    /**
     * @param value Allowed replication region
     */
    @JvmName("edlpuglmdpnryxla")
    public fun replicationRegion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReplicationRegion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationRegion = mapped
    }

    /**
     * @param value Allowed replication region
     */
    @JvmName("iumumnwagisnbwng")
    public fun replicationRegion(`value`: ReplicationRegion) {
        val toBeMapped = Either.ofRight<String, ReplicationRegion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.replicationRegion = mapped
    }

    /**
     * @param value Gets or sets scaleUnit where the namespace gets created
     */
    @JvmName("yldoueadbwvjifih")
    public suspend fun scaleUnit(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scaleUnit = mapped
    }

    /**
     * @param value Namespace status.
     */
    @JvmName("rukqgspbadnrgqfk")
    public suspend fun status(`value`: Either<String, NamespaceStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Namespace status.
     */
    @JvmName("popnytxmybiwtpbx")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NamespaceStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Namespace status.
     */
    @JvmName("hqrpolwkhdxhhgqb")
    public fun status(`value`: NamespaceStatus) {
        val toBeMapped = Either.ofRight<String, NamespaceStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Namespace SKU name.
     */
    @JvmName("eivgjuctnawlpufr")
    public suspend fun zoneRedundancy(`value`: Either<String, ZoneRedundancyPreference>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zoneRedundancy = mapped
    }

    /**
     * @param value Namespace SKU name.
     */
    @JvmName("rmcfvufsjphpgeht")
    public fun zoneRedundancy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ZoneRedundancyPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneRedundancy = mapped
    }

    /**
     * @param value Namespace SKU name.
     */
    @JvmName("amkpcwogutjupqei")
    public fun zoneRedundancy(`value`: ZoneRedundancyPreference) {
        val toBeMapped = Either.ofRight<String, ZoneRedundancyPreference>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zoneRedundancy = mapped
    }

    internal fun build(): NamespacePropertiesArgs = NamespacePropertiesArgs(
        dataCenter = dataCenter,
        namespaceType = namespaceType,
        networkAcls = networkAcls,
        pnsCredentials = pnsCredentials,
        provisioningState = provisioningState,
        publicNetworkAccess = publicNetworkAccess,
        replicationRegion = replicationRegion,
        scaleUnit = scaleUnit,
        status = status,
        zoneRedundancy = zoneRedundancy,
    )
}
