@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.NetworkAclsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of network authorization rules.
 * @property ipRules List of IP rules.
 * @property publicNetworkRule A default (public Internet) network authorization rule, which contains rights if no other network rule matches.
 */
public data class NetworkAclsArgs(
    public val ipRules: Output<List<IpRuleArgs>>? = null,
    public val publicNetworkRule: Output<PublicInternetAuthorizationRuleArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.NetworkAclsArgs> {
    override fun toJava(): com.pulumi.azurenative.notificationhubs.inputs.NetworkAclsArgs =
        com.pulumi.azurenative.notificationhubs.inputs.NetworkAclsArgs.builder()
            .ipRules(
                ipRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .publicNetworkRule(
                publicNetworkRule?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [NetworkAclsArgs].
 */
@PulumiTagMarker
public class NetworkAclsArgsBuilder internal constructor() {
    private var ipRules: Output<List<IpRuleArgs>>? = null

    private var publicNetworkRule: Output<PublicInternetAuthorizationRuleArgs>? = null

    /**
     * @param value List of IP rules.
     */
    @JvmName("naycqdnrdotwpyup")
    public suspend fun ipRules(`value`: Output<List<IpRuleArgs>>) {
        this.ipRules = value
    }

    @JvmName("hvwdqrwrnanqbepg")
    public suspend fun ipRules(vararg values: Output<IpRuleArgs>) {
        this.ipRules = Output.all(values.asList())
    }

    /**
     * @param values List of IP rules.
     */
    @JvmName("cgsisnlfdrtwxwhj")
    public suspend fun ipRules(values: List<Output<IpRuleArgs>>) {
        this.ipRules = Output.all(values)
    }

    /**
     * @param value A default (public Internet) network authorization rule, which contains rights if no other network rule matches.
     */
    @JvmName("yxqtxcflnphquyul")
    public suspend fun publicNetworkRule(`value`: Output<PublicInternetAuthorizationRuleArgs>) {
        this.publicNetworkRule = value
    }

    /**
     * @param value List of IP rules.
     */
    @JvmName("dpnqwuajeyqaclqr")
    public suspend fun ipRules(`value`: List<IpRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param argument List of IP rules.
     */
    @JvmName("sojeupdetfnowhtu")
    public suspend fun ipRules(argument: List<suspend IpRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { IpRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument List of IP rules.
     */
    @JvmName("dpidqjxfrydaohrv")
    public suspend fun ipRules(vararg argument: suspend IpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { IpRuleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param argument List of IP rules.
     */
    @JvmName("phssuhvaejlpqxko")
    public suspend fun ipRules(argument: suspend IpRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(IpRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.ipRules = mapped
    }

    /**
     * @param values List of IP rules.
     */
    @JvmName("eglcxdarrgehgogj")
    public suspend fun ipRules(vararg values: IpRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipRules = mapped
    }

    /**
     * @param value A default (public Internet) network authorization rule, which contains rights if no other network rule matches.
     */
    @JvmName("qiauwvwarbrjnxsu")
    public suspend fun publicNetworkRule(`value`: PublicInternetAuthorizationRuleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkRule = mapped
    }

    /**
     * @param argument A default (public Internet) network authorization rule, which contains rights if no other network rule matches.
     */
    @JvmName("sfchdhedolrckdfe")
    public suspend
    fun publicNetworkRule(argument: suspend PublicInternetAuthorizationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = PublicInternetAuthorizationRuleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.publicNetworkRule = mapped
    }

    internal fun build(): NetworkAclsArgs = NetworkAclsArgs(
        ipRules = ipRules,
        publicNetworkRule = publicNetworkRule,
    )
}
