@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.inputs

import com.pulumi.azurenative.notificationhubs.inputs.SharedAccessAuthorizationRulePropertiesArgs.builder
import com.pulumi.azurenative.notificationhubs.kotlin.enums.AccessRights
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * SharedAccessAuthorizationRule properties.
 * @property primaryKey Gets a base64-encoded 256-bit primary key for signing and
 * validating the SAS token.
 * @property rights Gets or sets the rights associated with the rule.
 * @property secondaryKey Gets a base64-encoded 256-bit primary key for signing and
 * validating the SAS token.
 */
public data class SharedAccessAuthorizationRulePropertiesArgs(
    public val primaryKey: Output<String>? = null,
    public val rights: Output<List<Either<String, AccessRights>>>,
    public val secondaryKey: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.notificationhubs.inputs.SharedAccessAuthorizationRulePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.notificationhubs.inputs.SharedAccessAuthorizationRulePropertiesArgs =
        com.pulumi.azurenative.notificationhubs.inputs.SharedAccessAuthorizationRulePropertiesArgs.builder()
            .primaryKey(primaryKey?.applyValue({ args0 -> args0 }))
            .rights(
                rights.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform(
                            { args0 -> args0 },
                            { args0 -> args0.let({ args0 -> args0.toJava() }) },
                        )
                    })
                }),
            )
            .secondaryKey(secondaryKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SharedAccessAuthorizationRulePropertiesArgs].
 */
@PulumiTagMarker
public class SharedAccessAuthorizationRulePropertiesArgsBuilder internal constructor() {
    private var primaryKey: Output<String>? = null

    private var rights: Output<List<Either<String, AccessRights>>>? = null

    private var secondaryKey: Output<String>? = null

    /**
     * @param value Gets a base64-encoded 256-bit primary key for signing and
     * validating the SAS token.
     */
    @JvmName("dumtnywypuskjvns")
    public suspend fun primaryKey(`value`: Output<String>) {
        this.primaryKey = value
    }

    /**
     * @param value Gets or sets the rights associated with the rule.
     */
    @JvmName("neuyypeiurbgnuqo")
    public suspend fun rights(`value`: Output<List<Either<String, AccessRights>>>) {
        this.rights = value
    }

    @JvmName("ikoydhcyafnonhsu")
    public suspend fun rights(vararg values: Output<Either<String, AccessRights>>) {
        this.rights = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets the rights associated with the rule.
     */
    @JvmName("vdancngxoaruljpp")
    public suspend fun rights(values: List<Output<Either<String, AccessRights>>>) {
        this.rights = Output.all(values)
    }

    /**
     * @param value Gets a base64-encoded 256-bit primary key for signing and
     * validating the SAS token.
     */
    @JvmName("eotyxblxpydhtsmu")
    public suspend fun secondaryKey(`value`: Output<String>) {
        this.secondaryKey = value
    }

    /**
     * @param value Gets a base64-encoded 256-bit primary key for signing and
     * validating the SAS token.
     */
    @JvmName("odqxtmeuodfhopsb")
    public suspend fun primaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryKey = mapped
    }

    /**
     * @param value Gets or sets the rights associated with the rule.
     */
    @JvmName("vsmfavfimcdyanvk")
    public suspend fun rights(`value`: List<Either<String, AccessRights>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param values Gets or sets the rights associated with the rule.
     */
    @JvmName("yvtxdnmcysybtlfy")
    public suspend fun rights(vararg values: Either<String, AccessRights>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rights = mapped
    }

    /**
     * @param value Gets a base64-encoded 256-bit primary key for signing and
     * validating the SAS token.
     */
    @JvmName("yyeusgbvyfguhlef")
    public suspend fun secondaryKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secondaryKey = mapped
    }

    internal fun build(): SharedAccessAuthorizationRulePropertiesArgs =
        SharedAccessAuthorizationRulePropertiesArgs(
            primaryKey = primaryKey,
            rights = rights ?: throw PulumiNullFieldException("rights"),
            secondaryKey = secondaryKey,
        )
}
