@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Response for the POST request that returns Namespace or NotificationHub access keys (connection strings).
 * @property keyName Gets or sets keyName of the created AuthorizationRule
 * @property primaryConnectionString Gets or sets primaryConnectionString of the AuthorizationRule.
 * @property primaryKey Gets or sets primaryKey of the created AuthorizationRule.
 * @property secondaryConnectionString Gets or sets secondaryConnectionString of the created
 * AuthorizationRule
 * @property secondaryKey Gets or sets secondaryKey of the created AuthorizationRule
 */
public data class ListNotificationHubKeysResult(
    public val keyName: String,
    public val primaryConnectionString: String,
    public val primaryKey: String,
    public val secondaryConnectionString: String,
    public val secondaryKey: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.ListNotificationHubKeysResult):
            ListNotificationHubKeysResult = ListNotificationHubKeysResult(
            keyName = javaType.keyName(),
            primaryConnectionString = javaType.primaryConnectionString(),
            primaryKey = javaType.primaryKey(),
            secondaryConnectionString = javaType.secondaryConnectionString(),
            secondaryKey = javaType.secondaryKey(),
        )
    }
}
