@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Description of a NotificationHub MpnsCredential.
 * @property certificateKey Gets or sets the certificate key for this credential.
 * @property mpnsCertificate Gets or sets the MPNS certificate.
 * @property thumbprint Gets or sets the MPNS certificate Thumbprint
 */
public data class MpnsCredentialPropertiesResponse(
    public val certificateKey: String,
    public val mpnsCertificate: String,
    public val thumbprint: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.MpnsCredentialPropertiesResponse):
            MpnsCredentialPropertiesResponse = MpnsCredentialPropertiesResponse(
            certificateKey = javaType.certificateKey(),
            mpnsCertificate = javaType.mpnsCertificate(),
            thumbprint = javaType.thumbprint(),
        )
    }
}
