@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * SharedAccessAuthorizationRule properties.
 * @property claimType Gets a string that describes the claim type
 * @property claimValue Gets a string that describes the claim value
 * @property createdTime Gets the created time for this rule
 * @property keyName Gets a string that describes the authorization rule.
 * @property modifiedTime Gets the last modified time for this rule
 * @property primaryKey Gets a base64-encoded 256-bit primary key for signing and
 * validating the SAS token.
 * @property revision Gets the revision number for the rule
 * @property rights Gets or sets the rights associated with the rule.
 * @property secondaryKey Gets a base64-encoded 256-bit primary key for signing and
 * validating the SAS token.
 */
public data class SharedAccessAuthorizationRulePropertiesResponse(
    public val claimType: String,
    public val claimValue: String,
    public val createdTime: String,
    public val keyName: String,
    public val modifiedTime: String,
    public val primaryKey: String? = null,
    public val revision: Int,
    public val rights: List<String>,
    public val secondaryKey: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.SharedAccessAuthorizationRulePropertiesResponse):
            SharedAccessAuthorizationRulePropertiesResponse =
            SharedAccessAuthorizationRulePropertiesResponse(
                claimType = javaType.claimType(),
                claimValue = javaType.claimValue(),
                createdTime = javaType.createdTime(),
                keyName = javaType.keyName(),
                modifiedTime = javaType.modifiedTime(),
                primaryKey = javaType.primaryKey().map({ args0 -> args0 }).orElse(null),
                revision = javaType.revision(),
                rights = javaType.rights().map({ args0 -> args0 }),
                secondaryKey = javaType.secondaryKey().map({ args0 -> args0 }).orElse(null),
            )
    }
}
