@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.notificationhubs.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The Sku description for a namespace
 * @property capacity Gets or sets the capacity of the resource
 * @property family Gets or sets the Sku Family
 * @property name Namespace SKU name.
 * @property size Gets or sets the Sku size
 * @property tier Gets or sets the tier of particular sku
 */
public data class SkuResponse(
    public val capacity: Int? = null,
    public val family: String? = null,
    public val name: String,
    public val size: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.notificationhubs.outputs.SkuResponse):
            SkuResponse = SkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            family = javaType.family().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            size = javaType.size().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
