@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.kotlin.outputs.HealthErrorDetailsResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.offazure.kotlin.outputs.HealthErrorDetailsResponse.Companion.toKotlin as healthErrorDetailsResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [HypervHostController].
 */
@PulumiTagMarker
public class HypervHostControllerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: HypervHostControllerArgs = HypervHostControllerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend HypervHostControllerArgsBuilder.() -> Unit) {
        val builder = HypervHostControllerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): HypervHostController {
        val builtJavaResource =
            com.pulumi.azurenative.offazure.HypervHostController(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return HypervHostController(builtJavaResource)
    }
}

/**
 * A host resource belonging to a site resource.
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### HypervHostController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hypervHostController = new AzureNative.OffAzure.HypervHostController("hypervHostController", new()
 *     {
 *         Fqdn = "okkwk",
 *         HostName = "XQ-753h-765DG2",
 *         ProvisioningState = "Created",
 *         ResourceGroupName = "rgmigrate",
 *         RunAsAccountId = "pjgyebznvfxnjzjqt",
 *         SiteName = "---7ed-q11Nx46-98",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewHypervHostController(ctx, "hypervHostController", &offazure.HypervHostControllerArgs{
 * 			Fqdn:              pulumi.String("okkwk"),
 * 			HostName:          pulumi.String("XQ-753h-765DG2"),
 * 			ProvisioningState: pulumi.String("Created"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			RunAsAccountId:    pulumi.String("pjgyebznvfxnjzjqt"),
 * 			SiteName:          pulumi.String("---7ed-q11Nx46-98"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.HypervHostController;
 * import com.pulumi.azurenative.offazure.HypervHostControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hypervHostController = new HypervHostController("hypervHostController", HypervHostControllerArgs.builder()
 *             .fqdn("okkwk")
 *             .hostName("XQ-753h-765DG2")
 *             .provisioningState("Created")
 *             .resourceGroupName("rgmigrate")
 *             .runAsAccountId("pjgyebznvfxnjzjqt")
 *             .siteName("---7ed-q11Nx46-98")
 *             .build());
 *     }
 * }
 * ```
 * ### HypervHostController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hypervHostController = new AzureNative.OffAzure.HypervHostController("hypervHostController", new()
 *     {
 *         HostName = "IIfm6suXoKL",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "-25mH3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewHypervHostController(ctx, "hypervHostController", &offazure.HypervHostControllerArgs{
 * 			HostName:          pulumi.String("IIfm6suXoKL"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("-25mH3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.HypervHostController;
 * import com.pulumi.azurenative.offazure.HypervHostControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hypervHostController = new HypervHostController("hypervHostController", HypervHostControllerArgs.builder()
 *             .hostName("IIfm6suXoKL")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("-25mH3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:HypervHostController kgosttkbfbrsge /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/hypervSites/{siteName}/hosts/{hostName}
 * ```
 */
public class HypervHostController internal constructor(
    override val javaResource: com.pulumi.azurenative.offazure.HypervHostController,
) : KotlinCustomResource(javaResource, HypervHostControllerMapper) {
    /**
     * Gets the timestamp marking Hyper-V host creation.
     */
    public val createdTimestamp: Output<String>
        get() = javaResource.createdTimestamp().applyValue({ args0 -> args0 })

    /**
     * Gets the errors.
     */
    public val errors: Output<List<HealthErrorDetailsResponse>>
        get() = javaResource.errors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    healthErrorDetailsResponseToKotlin(args0)
                })
            })
        })

    /**
     * Gets or sets the FQDN/IPAddress of the Hyper-V host.
     */
    public val fqdn: Output<String>?
        get() = javaResource.fqdn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>?
        get() = javaResource.provisioningState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Gets or sets the run as account ID of the Hyper-V host.
     */
    public val runAsAccountId: Output<String>?
        get() = javaResource.runAsAccountId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Gets the timestamp marking last updated on the Hyper-V host.
     */
    public val updatedTimestamp: Output<String>
        get() = javaResource.updatedTimestamp().applyValue({ args0 -> args0 })

    /**
     * Gets the version of the Hyper-V host.
     */
    public val version: Output<String>
        get() = javaResource.version().applyValue({ args0 -> args0 })
}

public object HypervHostControllerMapper : ResourceMapper<HypervHostController> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazure.HypervHostController::class == javaResource::class

    override fun map(javaResource: Resource): HypervHostController = HypervHostController(
        javaResource
            as com.pulumi.azurenative.offazure.HypervHostController,
    )
}

/**
 * @see [HypervHostController].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [HypervHostController].
 */
public suspend fun hypervHostController(
    name: String,
    block: suspend HypervHostControllerResourceBuilder.() -> Unit,
): HypervHostController {
    val builder = HypervHostControllerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [HypervHostController].
 * @param name The _unique_ name of the resulting resource.
 */
public fun hypervHostController(name: String): HypervHostController {
    val builder = HypervHostControllerResourceBuilder()
    builder.name(name)
    return builder.build()
}
