@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.kotlin.outputs.SiteAppliancePropertiesResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.offazure.kotlin.outputs.SiteAppliancePropertiesResponse.Companion.toKotlin as siteAppliancePropertiesResponseToKotlin
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [SqlSitesController].
 */
@PulumiTagMarker
public class SqlSitesControllerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlSitesControllerArgs = SqlSitesControllerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlSitesControllerArgsBuilder.() -> Unit) {
        val builder = SqlSitesControllerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SqlSitesController {
        val builtJavaResource =
            com.pulumi.azurenative.offazure.SqlSitesController(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlSitesController(builtJavaResource)
    }
}

/**
 * SQL site web model.
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### SqlSitesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlSitesController = new AzureNative.OffAzure.SqlSitesController("sqlSitesController", new()
 *     {
 *         DiscoveryScenario = "Migrate",
 *         ResourceGroupName = "rgmigrate",
 *         SiteAppliancePropertiesCollection = new[]
 *         {
 *             new AzureNative.OffAzure.Inputs.SiteAppliancePropertiesArgs
 *             {
 *                 AgentDetails = new AzureNative.OffAzure.Inputs.SiteAgentPropertiesArgs
 *                 {
 *                     KeyVaultId = "awxurtbjmofxuciewsqfgpkccpzw",
 *                     KeyVaultUri = "qizphgqwage",
 *                 },
 *                 ApplianceName = "zpbkpigahvexsxevwafzgsu",
 *                 ServicePrincipalIdentityDetails = new AzureNative.OffAzure.Inputs.SiteSpnPropertiesArgs
 *                 {
 *                     AadAuthority = "yanzipdww",
 *                     ApplicationId = "tspgrujepxyxuprkqvfuqbbjrweeqa",
 *                     Audience = "oepwfaozztzvegmzvswafvotj",
 *                     ObjectId = "tqrjngpgxnnto",
 *                     RawCertData = "dotvgkslkmsgvtekgojnhcdrryk",
 *                     TenantId = "vesmyhu",
 *                 },
 *             },
 *         },
 *         SiteName = "qo36fi7J8y-b",
 *         SqlSiteName = "A-4l5sbX5",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewSqlSitesController(ctx, "sqlSitesController", &offazure.SqlSitesControllerArgs{
 * 			DiscoveryScenario: pulumi.String("Migrate"),
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteAppliancePropertiesCollection: []offazure.SiteAppliancePropertiesArgs{
 * 				{
 * 					AgentDetails: {
 * 						KeyVaultId:  pulumi.String("awxurtbjmofxuciewsqfgpkccpzw"),
 * 						KeyVaultUri: pulumi.String("qizphgqwage"),
 * 					},
 * 					ApplianceName: pulumi.String("zpbkpigahvexsxevwafzgsu"),
 * 					ServicePrincipalIdentityDetails: {
 * 						AadAuthority:  pulumi.String("yanzipdww"),
 * 						ApplicationId: pulumi.String("tspgrujepxyxuprkqvfuqbbjrweeqa"),
 * 						Audience:      pulumi.String("oepwfaozztzvegmzvswafvotj"),
 * 						ObjectId:      pulumi.String("tqrjngpgxnnto"),
 * 						RawCertData:   pulumi.String("dotvgkslkmsgvtekgojnhcdrryk"),
 * 						TenantId:      pulumi.String("vesmyhu"),
 * 					},
 * 				},
 * 			},
 * 			SiteName:    pulumi.String("qo36fi7J8y-b"),
 * 			SqlSiteName: pulumi.String("A-4l5sbX5"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.SqlSitesController;
 * import com.pulumi.azurenative.offazure.SqlSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlSitesController = new SqlSitesController("sqlSitesController", SqlSitesControllerArgs.builder()
 *             .discoveryScenario("Migrate")
 *             .resourceGroupName("rgmigrate")
 *             .siteAppliancePropertiesCollection(Map.ofEntries(
 *                 Map.entry("agentDetails", Map.ofEntries(
 *                     Map.entry("keyVaultId", "awxurtbjmofxuciewsqfgpkccpzw"),
 *                     Map.entry("keyVaultUri", "qizphgqwage")
 *                 )),
 *                 Map.entry("applianceName", "zpbkpigahvexsxevwafzgsu"),
 *                 Map.entry("servicePrincipalIdentityDetails", Map.ofEntries(
 *                     Map.entry("aadAuthority", "yanzipdww"),
 *                     Map.entry("applicationId", "tspgrujepxyxuprkqvfuqbbjrweeqa"),
 *                     Map.entry("audience", "oepwfaozztzvegmzvswafvotj"),
 *                     Map.entry("objectId", "tqrjngpgxnnto"),
 *                     Map.entry("rawCertData", "dotvgkslkmsgvtekgojnhcdrryk"),
 *                     Map.entry("tenantId", "vesmyhu")
 *                 ))
 *             ))
 *             .siteName("qo36fi7J8y-b")
 *             .sqlSiteName("A-4l5sbX5")
 *             .build());
 *     }
 * }
 * ```
 * ### SqlSitesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlSitesController = new AzureNative.OffAzure.SqlSitesController("sqlSitesController", new()
 *     {
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "Ag5-Ex4n7G5Qn-5-yHL5",
 *         SqlSiteName = "-03--VkVPfDq5",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewSqlSitesController(ctx, "sqlSitesController", &offazure.SqlSitesControllerArgs{
 * 			ResourceGroupName: pulumi.String("rgmigrate"),
 * 			SiteName:          pulumi.String("Ag5-Ex4n7G5Qn-5-yHL5"),
 * 			SqlSiteName:       pulumi.String("-03--VkVPfDq5"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.SqlSitesController;
 * import com.pulumi.azurenative.offazure.SqlSitesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlSitesController = new SqlSitesController("sqlSitesController", SqlSitesControllerArgs.builder()
 *             .resourceGroupName("rgmigrate")
 *             .siteName("Ag5-Ex4n7G5Qn-5-yHL5")
 *             .sqlSiteName("-03--VkVPfDq5")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:SqlSitesController kfcekxrevjpsqnaphpqrwnwonqycgl /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/masterSites/{siteName}/sqlSites/{sqlSiteName}
 * ```
 */
public class SqlSitesController internal constructor(
    override val javaResource: com.pulumi.azurenative.offazure.SqlSitesController,
) : KotlinCustomResource(javaResource, SqlSitesControllerMapper) {
    /**
     * Gets or sets the discovery scenario.
     */
    public val discoveryScenario: Output<String>?
        get() = javaResource.discoveryScenario().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * provisioning state enum
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Gets the service endpoint.
     */
    public val serviceEndpoint: Output<String>
        get() = javaResource.serviceEndpoint().applyValue({ args0 -> args0 })

    /**
     * Gets or sets the appliance details used by service to communicate
     * to the appliance.
     */
    public val siteAppliancePropertiesCollection: Output<List<SiteAppliancePropertiesResponse>>?
        get() = javaResource.siteAppliancePropertiesCollection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        siteAppliancePropertiesResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SqlSitesControllerMapper : ResourceMapper<SqlSitesController> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazure.SqlSitesController::class == javaResource::class

    override fun map(javaResource: Resource): SqlSitesController = SqlSitesController(
        javaResource as
            com.pulumi.azurenative.offazure.SqlSitesController,
    )
}

/**
 * @see [SqlSitesController].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlSitesController].
 */
public suspend fun sqlSitesController(
    name: String,
    block: suspend SqlSitesControllerResourceBuilder.() -> Unit,
): SqlSitesController {
    val builder = SqlSitesControllerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlSitesController].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlSitesController(name: String): SqlSitesController {
    val builder = SqlSitesControllerResourceBuilder()
    builder.name(name)
    return builder.build()
}
