@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin

import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [WebAppDiscoverySiteDataSourcesController].
 */
@PulumiTagMarker
public class WebAppDiscoverySiteDataSourcesControllerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WebAppDiscoverySiteDataSourcesControllerArgs =
        WebAppDiscoverySiteDataSourcesControllerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend WebAppDiscoverySiteDataSourcesControllerArgsBuilder.() -> Unit) {
        val builder = WebAppDiscoverySiteDataSourcesControllerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): WebAppDiscoverySiteDataSourcesController {
        val builtJavaResource =
            com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesController(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return WebAppDiscoverySiteDataSourcesController(builtJavaResource)
    }
}

/**
 * Web app data source web model.
 * Azure REST API version: 2023-06-06.
 * Other available API versions: 2023-10-01-preview.
 * ## Example Usage
 * ### WebAppDiscoverySiteDataSourcesController_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppDiscoverySiteDataSourcesController = new AzureNative.OffAzure.WebAppDiscoverySiteDataSourcesController("webAppDiscoverySiteDataSourcesController", new()
 *     {
 *         DiscoverySiteDataSourceName = "171iiIY1M39-M--VU2x8uOy",
 *         DiscoverySiteId = "fwkwva",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "0M4C6JZc",
 *         WebAppSiteName = "QhlGHU7obm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewWebAppDiscoverySiteDataSourcesController(ctx, "webAppDiscoverySiteDataSourcesController", &offazure.WebAppDiscoverySiteDataSourcesControllerArgs{
 * 			DiscoverySiteDataSourceName: pulumi.String("171iiIY1M39-M--VU2x8uOy"),
 * 			DiscoverySiteId:             pulumi.String("fwkwva"),
 * 			ResourceGroupName:           pulumi.String("rgmigrate"),
 * 			SiteName:                    pulumi.String("0M4C6JZc"),
 * 			WebAppSiteName:              pulumi.String("QhlGHU7obm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesController;
 * import com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppDiscoverySiteDataSourcesController = new WebAppDiscoverySiteDataSourcesController("webAppDiscoverySiteDataSourcesController", WebAppDiscoverySiteDataSourcesControllerArgs.builder()
 *             .discoverySiteDataSourceName("171iiIY1M39-M--VU2x8uOy")
 *             .discoverySiteId("fwkwva")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("0M4C6JZc")
 *             .webAppSiteName("QhlGHU7obm")
 *             .build());
 *     }
 * }
 * ```
 * ### WebAppDiscoverySiteDataSourcesController_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var webAppDiscoverySiteDataSourcesController = new AzureNative.OffAzure.WebAppDiscoverySiteDataSourcesController("webAppDiscoverySiteDataSourcesController", new()
 *     {
 *         DiscoverySiteDataSourceName = "Q-38555Y-2-8-6-bdZk2y",
 *         ResourceGroupName = "rgmigrate",
 *         SiteName = "257-4BP-1j",
 *         WebAppSiteName = "S--3265vli3j4X--Vy-J",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazure/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazure.NewWebAppDiscoverySiteDataSourcesController(ctx, "webAppDiscoverySiteDataSourcesController", &offazure.WebAppDiscoverySiteDataSourcesControllerArgs{
 * 			DiscoverySiteDataSourceName: pulumi.String("Q-38555Y-2-8-6-bdZk2y"),
 * 			ResourceGroupName:           pulumi.String("rgmigrate"),
 * 			SiteName:                    pulumi.String("257-4BP-1j"),
 * 			WebAppSiteName:              pulumi.String("S--3265vli3j4X--Vy-J"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesController;
 * import com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesControllerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var webAppDiscoverySiteDataSourcesController = new WebAppDiscoverySiteDataSourcesController("webAppDiscoverySiteDataSourcesController", WebAppDiscoverySiteDataSourcesControllerArgs.builder()
 *             .discoverySiteDataSourceName("Q-38555Y-2-8-6-bdZk2y")
 *             .resourceGroupName("rgmigrate")
 *             .siteName("257-4BP-1j")
 *             .webAppSiteName("S--3265vli3j4X--Vy-J")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazure:WebAppDiscoverySiteDataSourcesController torp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzure/masterSites/{siteName}/webAppSites/{webAppSiteName}/discoverySiteDataSources/{discoverySiteDataSourceName}
 * ```
 */
public class WebAppDiscoverySiteDataSourcesController internal constructor(
    override val javaResource:
    com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesController,
) : KotlinCustomResource(javaResource, WebAppDiscoverySiteDataSourcesControllerMapper) {
    /**
     * Gets or sets the discovery site Id.
     */
    public val discoverySiteId: Output<String>?
        get() = javaResource.discoverySiteId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * provisioning state enum
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WebAppDiscoverySiteDataSourcesControllerMapper :
    ResourceMapper<WebAppDiscoverySiteDataSourcesController> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesController::class == javaResource::class

    override fun map(javaResource: Resource): WebAppDiscoverySiteDataSourcesController =
        WebAppDiscoverySiteDataSourcesController(
            javaResource as
                com.pulumi.azurenative.offazure.WebAppDiscoverySiteDataSourcesController,
        )
}

/**
 * @see [WebAppDiscoverySiteDataSourcesController].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [WebAppDiscoverySiteDataSourcesController].
 */
public suspend fun webAppDiscoverySiteDataSourcesController(
    name: String,
    block: suspend WebAppDiscoverySiteDataSourcesControllerResourceBuilder.() -> Unit,
):
    WebAppDiscoverySiteDataSourcesController {
    val builder = WebAppDiscoverySiteDataSourcesControllerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [WebAppDiscoverySiteDataSourcesController].
 * @param name The _unique_ name of the resulting resource.
 */
public fun webAppDiscoverySiteDataSourcesController(name: String):
    WebAppDiscoverySiteDataSourcesController {
    val builder = WebAppDiscoverySiteDataSourcesControllerResourceBuilder()
    builder.name(name)
    return builder.build()
}
