@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.inputs

import com.pulumi.azurenative.offazure.inputs.GetServerSitesControllerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property siteName Site name
 */
public data class GetServerSitesControllerPlainArgs(
    public val resourceGroupName: String,
    public val siteName: String,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.inputs.GetServerSitesControllerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.inputs.GetServerSitesControllerPlainArgs =
        com.pulumi.azurenative.offazure.inputs.GetServerSitesControllerPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .siteName(siteName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerSitesControllerPlainArgs].
 */
@PulumiTagMarker
public class GetServerSitesControllerPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var siteName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nclhtopucrueccys")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Site name
     */
    @JvmName("gprtoyrlbxaskhsb")
    public suspend fun siteName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.siteName = mapped
    }

    internal fun build(): GetServerSitesControllerPlainArgs = GetServerSitesControllerPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        siteName = siteName ?: throw PulumiNullFieldException("siteName"),
    )
}
