@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.inputs

import com.pulumi.azurenative.offazure.inputs.SiteSpnPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Class for site properties.
 * @property aadAuthority Gets or sets the AAD Authority URL which was used to request the token for
 * the
 *             service principal.
 * @property applicationId Gets or sets the application/client Id for the service principal with which
 * the
 *             on-premise management/data plane components would communicate
 * with our Azure
 *             services.
 * @property audience Gets or sets the intended audience for the service principal.
 * @property objectId Gets or sets the object Id of the service principal with which the on-premise
 *            management/data plane components would communicate with our Azure
 * services.
 * @property rawCertData Gets or sets the raw certificate data for building certificate expiry flows.
 * @property tenantId Gets or sets the tenant Id for the service principal with which the
 * on-premise
 *             management/data plane components would communicate with
 * our Azure services.
 */
public data class SiteSpnPropertiesArgs(
    public val aadAuthority: Output<String>? = null,
    public val applicationId: Output<String>? = null,
    public val audience: Output<String>? = null,
    public val objectId: Output<String>? = null,
    public val rawCertData: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazure.inputs.SiteSpnPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.offazure.inputs.SiteSpnPropertiesArgs =
        com.pulumi.azurenative.offazure.inputs.SiteSpnPropertiesArgs.builder()
            .aadAuthority(aadAuthority?.applyValue({ args0 -> args0 }))
            .applicationId(applicationId?.applyValue({ args0 -> args0 }))
            .audience(audience?.applyValue({ args0 -> args0 }))
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .rawCertData(rawCertData?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SiteSpnPropertiesArgs].
 */
@PulumiTagMarker
public class SiteSpnPropertiesArgsBuilder internal constructor() {
    private var aadAuthority: Output<String>? = null

    private var applicationId: Output<String>? = null

    private var audience: Output<String>? = null

    private var objectId: Output<String>? = null

    private var rawCertData: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Gets or sets the AAD Authority URL which was used to request the token for
     * the
     *             service principal.
     */
    @JvmName("pphcceuqnnqpsyux")
    public suspend fun aadAuthority(`value`: Output<String>) {
        this.aadAuthority = value
    }

    /**
     * @param value Gets or sets the application/client Id for the service principal with which
     * the
     *             on-premise management/data plane components would communicate
     * with our Azure
     *             services.
     */
    @JvmName("epmqbgwyrrsbxlgc")
    public suspend fun applicationId(`value`: Output<String>) {
        this.applicationId = value
    }

    /**
     * @param value Gets or sets the intended audience for the service principal.
     */
    @JvmName("ytetmovaphvbwxrv")
    public suspend fun audience(`value`: Output<String>) {
        this.audience = value
    }

    /**
     * @param value Gets or sets the object Id of the service principal with which the on-premise
     *            management/data plane components would communicate with our Azure
     * services.
     */
    @JvmName("mwufinnnisxbwvww")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value Gets or sets the raw certificate data for building certificate expiry flows.
     */
    @JvmName("evhotiehscblwieu")
    public suspend fun rawCertData(`value`: Output<String>) {
        this.rawCertData = value
    }

    /**
     * @param value Gets or sets the tenant Id for the service principal with which the
     * on-premise
     *             management/data plane components would communicate with
     * our Azure services.
     */
    @JvmName("rhxgwisyfftubsxt")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Gets or sets the AAD Authority URL which was used to request the token for
     * the
     *             service principal.
     */
    @JvmName("qrsgpsebinjhauhi")
    public suspend fun aadAuthority(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aadAuthority = mapped
    }

    /**
     * @param value Gets or sets the application/client Id for the service principal with which
     * the
     *             on-premise management/data plane components would communicate
     * with our Azure
     *             services.
     */
    @JvmName("yxquprukknuvsnuj")
    public suspend fun applicationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationId = mapped
    }

    /**
     * @param value Gets or sets the intended audience for the service principal.
     */
    @JvmName("jmvsaplmgfbnaeom")
    public suspend fun audience(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audience = mapped
    }

    /**
     * @param value Gets or sets the object Id of the service principal with which the on-premise
     *            management/data plane components would communicate with our Azure
     * services.
     */
    @JvmName("hddsumcrsndtqpko")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value Gets or sets the raw certificate data for building certificate expiry flows.
     */
    @JvmName("ipymtvlnyllciqdl")
    public suspend fun rawCertData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rawCertData = mapped
    }

    /**
     * @param value Gets or sets the tenant Id for the service principal with which the
     * on-premise
     *             management/data plane components would communicate with
     * our Azure services.
     */
    @JvmName("wdayvrlugmtmxubh")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): SiteSpnPropertiesArgs = SiteSpnPropertiesArgs(
        aadAuthority = aadAuthority,
        applicationId = applicationId,
        audience = audience,
        objectId = objectId,
        rawCertData = rawCertData,
        tenantId = tenantId,
    )
}
