@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A MasterSite
 * @property allowMultipleSites Gets or sets a value indicating whether multiple sites per site type are
 * allowed.
 * @property customerStorageAccountArmId Gets or sets a value for customer storage account ARM id.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property nestedSites Gets the nested sites under Master Site.
 * @property privateEndpointConnections Gets the private endpoint connections.
 * @property provisioningState provisioning state enum
 * @property publicNetworkAccess Gets or sets the state of public network access.
 * @property sites Gets or sets the sites that are a part of Master Site.
 *             The key
 * should contain the Site ARM name.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetMasterSitesControllerResult(
    public val allowMultipleSites: Boolean? = null,
    public val customerStorageAccountArmId: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val nestedSites: List<String>,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val sites: List<String>? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.GetMasterSitesControllerResult):
            GetMasterSitesControllerResult = GetMasterSitesControllerResult(
            allowMultipleSites = javaType.allowMultipleSites().map({ args0 -> args0 }).orElse(null),
            customerStorageAccountArmId = javaType.customerStorageAccountArmId().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            nestedSites = javaType.nestedSites().map({ args0 -> args0 }),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.offazure.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            sites = javaType.sites().map({ args0 -> args0 }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
