@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * REST model used to encapsulate Private Link properties for tracked resources.
 * @property groupIds array of group ids
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property privateEndpoint private endpoints
 * @property privateLinkServiceConnectionState private endpoints connection state
 * @property provisioningState provisioning state enum
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class PrivateEndpointConnectionResponse(
    public val groupIds: List<String>,
    public val id: String,
    public val name: String,
    public val privateEndpoint: ResourceIdResponse,
    public val privateLinkServiceConnectionState: PrivateLinkServiceConnectionStateResponse? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.PrivateEndpointConnectionResponse):
            PrivateEndpointConnectionResponse = PrivateEndpointConnectionResponse(
            groupIds = javaType.groupIds().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            privateEndpoint = javaType.privateEndpoint().let({ args0 ->
                com.pulumi.azurenative.offazure.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
            }),
            privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.offazure.kotlin.outputs.PrivateLinkServiceConnectionStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.offazure.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
