@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazure.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Class for site properties.
 * @property aadAuthority Gets or sets the AAD Authority URL which was used to request the token for
 * the
 *             service principal.
 * @property applicationId Gets or sets the application/client Id for the service principal with which
 * the
 *             on-premise management/data plane components would communicate
 * with our Azure
 *             services.
 * @property audience Gets or sets the intended audience for the service principal.
 * @property objectId Gets or sets the object Id of the service principal with which the on-premise
 *            management/data plane components would communicate with our Azure
 * services.
 * @property rawCertData Gets or sets the raw certificate data for building certificate expiry flows.
 * @property tenantId Gets or sets the tenant Id for the service principal with which the
 * on-premise
 *             management/data plane components would communicate with
 * our Azure services.
 */
public data class SiteSpnPropertiesResponse(
    public val aadAuthority: String? = null,
    public val applicationId: String? = null,
    public val audience: String? = null,
    public val objectId: String? = null,
    public val rawCertData: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.offazure.outputs.SiteSpnPropertiesResponse):
            SiteSpnPropertiesResponse = SiteSpnPropertiesResponse(
            aadAuthority = javaType.aadAuthority().map({ args0 -> args0 }).orElse(null),
            applicationId = javaType.applicationId().map({ args0 -> args0 }).orElse(null),
            audience = javaType.audience().map({ args0 -> args0 }).orElse(null),
            objectId = javaType.objectId().map({ args0 -> args0 }).orElse(null),
            rawCertData = javaType.rawCertData().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
