@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin

import com.pulumi.azurenative.offazurespringboot.kotlin.outputs.SpringbootsitesModelResponseExtendedLocation
import com.pulumi.azurenative.offazurespringboot.kotlin.outputs.SpringbootsitesPropertiesResponse
import com.pulumi.azurenative.offazurespringboot.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.offazurespringboot.kotlin.outputs.SpringbootsitesModelResponseExtendedLocation.Companion.toKotlin as springbootsitesModelResponseExtendedLocationToKotlin
import com.pulumi.azurenative.offazurespringboot.kotlin.outputs.SpringbootsitesPropertiesResponse.Companion.toKotlin as springbootsitesPropertiesResponseToKotlin
import com.pulumi.azurenative.offazurespringboot.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Springbootsite].
 */
@PulumiTagMarker
public class SpringbootsiteResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SpringbootsiteArgs = SpringbootsiteArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SpringbootsiteArgsBuilder.() -> Unit) {
        val builder = SpringbootsiteArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Springbootsite {
        val builtJavaResource =
            com.pulumi.azurenative.offazurespringboot.Springbootsite(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Springbootsite(builtJavaResource)
    }
}

/**
 * The springbootsites envelope resource definition.
 * Azure REST API version: 2023-01-01-preview.
 * ## Example Usage
 * ### springbootsites_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var springbootsite = new AzureNative.OffAzureSpringBoot.Springbootsite("springbootsite", new()
 *     {
 *         ExtendedLocation = new AzureNative.OffAzureSpringBoot.Inputs.SpringbootsitesModelExtendedLocationArgs
 *         {
 *             Name = "rywvpbfsqovhlfirtwisugsdsfsgf",
 *             Type = "lvsb",
 *         },
 *         Location = "tgobtvxktootwhhvjtsmpddvlqlrq",
 *         Properties = new AzureNative.OffAzureSpringBoot.Inputs.SpringbootsitesPropertiesArgs
 *         {
 *             MasterSiteId = "xsoimrgshsactearljwuljmi",
 *             MigrateProjectId = "wwuattybgco",
 *         },
 *         ResourceGroupName = "rgspringbootsites",
 *         SpringbootsitesName = "xrmzlavpewxtfeitghdrj",
 *         Tags =
 *         {
 *             { "key3558", "xeuhtglamqzj" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazurespringboot/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazurespringboot.NewSpringbootsite(ctx, "springbootsite", &offazurespringboot.SpringbootsiteArgs{
 * 			ExtendedLocation: &offazurespringboot.SpringbootsitesModelExtendedLocationArgs{
 * 				Name: pulumi.String("rywvpbfsqovhlfirtwisugsdsfsgf"),
 * 				Type: pulumi.String("lvsb"),
 * 			},
 * 			Location: pulumi.String("tgobtvxktootwhhvjtsmpddvlqlrq"),
 * 			Properties: &offazurespringboot.SpringbootsitesPropertiesArgs{
 * 				MasterSiteId:     pulumi.String("xsoimrgshsactearljwuljmi"),
 * 				MigrateProjectId: pulumi.String("wwuattybgco"),
 * 			},
 * 			ResourceGroupName:   pulumi.String("rgspringbootsites"),
 * 			SpringbootsitesName: pulumi.String("xrmzlavpewxtfeitghdrj"),
 * 			Tags: pulumi.StringMap{
 * 				"key3558": pulumi.String("xeuhtglamqzj"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazurespringboot.Springbootsite;
 * import com.pulumi.azurenative.offazurespringboot.SpringbootsiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var springbootsite = new Springbootsite("springbootsite", SpringbootsiteArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "rywvpbfsqovhlfirtwisugsdsfsgf"),
 *                 Map.entry("type", "lvsb")
 *             ))
 *             .location("tgobtvxktootwhhvjtsmpddvlqlrq")
 *             .properties(Map.ofEntries(
 *                 Map.entry("masterSiteId", "xsoimrgshsactearljwuljmi"),
 *                 Map.entry("migrateProjectId", "wwuattybgco")
 *             ))
 *             .resourceGroupName("rgspringbootsites")
 *             .springbootsitesName("xrmzlavpewxtfeitghdrj")
 *             .tags(Map.of("key3558", "xeuhtglamqzj"))
 *             .build());
 *     }
 * }
 * ```
 * ### springbootsites_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var springbootsite = new AzureNative.OffAzureSpringBoot.Springbootsite("springbootsite", new()
 *     {
 *         Location = "tgobtvxktootwhhvjtsmpddvlqlrq",
 *         ResourceGroupName = "rgspringbootsites",
 *         SpringbootsitesName = "xrmzlavpewxtfeitghdrj",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazurespringboot/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazurespringboot.NewSpringbootsite(ctx, "springbootsite", &offazurespringboot.SpringbootsiteArgs{
 * 			Location:            pulumi.String("tgobtvxktootwhhvjtsmpddvlqlrq"),
 * 			ResourceGroupName:   pulumi.String("rgspringbootsites"),
 * 			SpringbootsitesName: pulumi.String("xrmzlavpewxtfeitghdrj"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazurespringboot.Springbootsite;
 * import com.pulumi.azurenative.offazurespringboot.SpringbootsiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var springbootsite = new Springbootsite("springbootsite", SpringbootsiteArgs.builder()
 *             .location("tgobtvxktootwhhvjtsmpddvlqlrq")
 *             .resourceGroupName("rgspringbootsites")
 *             .springbootsitesName("xrmzlavpewxtfeitghdrj")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazurespringboot:Springbootsite jjyngfg /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}
 * ```
 */
public class Springbootsite internal constructor(
    override val javaResource: com.pulumi.azurenative.offazurespringboot.Springbootsite,
) : KotlinCustomResource(javaResource, SpringbootsiteMapper) {
    /**
     * The extended location definition.
     */
    public val extendedLocation: Output<SpringbootsitesModelResponseExtendedLocation>?
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    springbootsitesModelResponseExtendedLocationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The springbootsites resource definition.
     */
    public val properties: Output<SpringbootsitesPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                springbootsitesPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SpringbootsiteMapper : ResourceMapper<Springbootsite> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.offazurespringboot.Springbootsite::class == javaResource::class

    override fun map(javaResource: Resource): Springbootsite = Springbootsite(
        javaResource as
            com.pulumi.azurenative.offazurespringboot.Springbootsite,
    )
}

/**
 * @see [Springbootsite].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Springbootsite].
 */
public suspend fun springbootsite(
    name: String,
    block: suspend SpringbootsiteResourceBuilder.() -> Unit,
): Springbootsite {
    val builder = SpringbootsiteResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Springbootsite].
 * @param name The _unique_ name of the resulting resource.
 */
public fun springbootsite(name: String): Springbootsite {
    val builder = SpringbootsiteResourceBuilder()
    builder.name(name)
    return builder.build()
}
