@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin

import com.pulumi.azurenative.offazurespringboot.SpringbootsiteArgs.builder
import com.pulumi.azurenative.offazurespringboot.kotlin.inputs.SpringbootsitesModelExtendedLocationArgs
import com.pulumi.azurenative.offazurespringboot.kotlin.inputs.SpringbootsitesModelExtendedLocationArgsBuilder
import com.pulumi.azurenative.offazurespringboot.kotlin.inputs.SpringbootsitesPropertiesArgs
import com.pulumi.azurenative.offazurespringboot.kotlin.inputs.SpringbootsitesPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The springbootsites envelope resource definition.
 * Azure REST API version: 2023-01-01-preview.
 * ## Example Usage
 * ### springbootsites_CreateOrUpdate_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var springbootsite = new AzureNative.OffAzureSpringBoot.Springbootsite("springbootsite", new()
 *     {
 *         ExtendedLocation = new AzureNative.OffAzureSpringBoot.Inputs.SpringbootsitesModelExtendedLocationArgs
 *         {
 *             Name = "rywvpbfsqovhlfirtwisugsdsfsgf",
 *             Type = "lvsb",
 *         },
 *         Location = "tgobtvxktootwhhvjtsmpddvlqlrq",
 *         Properties = new AzureNative.OffAzureSpringBoot.Inputs.SpringbootsitesPropertiesArgs
 *         {
 *             MasterSiteId = "xsoimrgshsactearljwuljmi",
 *             MigrateProjectId = "wwuattybgco",
 *         },
 *         ResourceGroupName = "rgspringbootsites",
 *         SpringbootsitesName = "xrmzlavpewxtfeitghdrj",
 *         Tags =
 *         {
 *             { "key3558", "xeuhtglamqzj" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazurespringboot/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazurespringboot.NewSpringbootsite(ctx, "springbootsite", &offazurespringboot.SpringbootsiteArgs{
 * 			ExtendedLocation: &offazurespringboot.SpringbootsitesModelExtendedLocationArgs{
 * 				Name: pulumi.String("rywvpbfsqovhlfirtwisugsdsfsgf"),
 * 				Type: pulumi.String("lvsb"),
 * 			},
 * 			Location: pulumi.String("tgobtvxktootwhhvjtsmpddvlqlrq"),
 * 			Properties: &offazurespringboot.SpringbootsitesPropertiesArgs{
 * 				MasterSiteId:     pulumi.String("xsoimrgshsactearljwuljmi"),
 * 				MigrateProjectId: pulumi.String("wwuattybgco"),
 * 			},
 * 			ResourceGroupName:   pulumi.String("rgspringbootsites"),
 * 			SpringbootsitesName: pulumi.String("xrmzlavpewxtfeitghdrj"),
 * 			Tags: pulumi.StringMap{
 * 				"key3558": pulumi.String("xeuhtglamqzj"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazurespringboot.Springbootsite;
 * import com.pulumi.azurenative.offazurespringboot.SpringbootsiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var springbootsite = new Springbootsite("springbootsite", SpringbootsiteArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "rywvpbfsqovhlfirtwisugsdsfsgf"),
 *                 Map.entry("type", "lvsb")
 *             ))
 *             .location("tgobtvxktootwhhvjtsmpddvlqlrq")
 *             .properties(Map.ofEntries(
 *                 Map.entry("masterSiteId", "xsoimrgshsactearljwuljmi"),
 *                 Map.entry("migrateProjectId", "wwuattybgco")
 *             ))
 *             .resourceGroupName("rgspringbootsites")
 *             .springbootsitesName("xrmzlavpewxtfeitghdrj")
 *             .tags(Map.of("key3558", "xeuhtglamqzj"))
 *             .build());
 *     }
 * }
 * ```
 * ### springbootsites_CreateOrUpdate_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var springbootsite = new AzureNative.OffAzureSpringBoot.Springbootsite("springbootsite", new()
 *     {
 *         Location = "tgobtvxktootwhhvjtsmpddvlqlrq",
 *         ResourceGroupName = "rgspringbootsites",
 *         SpringbootsitesName = "xrmzlavpewxtfeitghdrj",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/offazurespringboot/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := offazurespringboot.NewSpringbootsite(ctx, "springbootsite", &offazurespringboot.SpringbootsiteArgs{
 * 			Location:            pulumi.String("tgobtvxktootwhhvjtsmpddvlqlrq"),
 * 			ResourceGroupName:   pulumi.String("rgspringbootsites"),
 * 			SpringbootsitesName: pulumi.String("xrmzlavpewxtfeitghdrj"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.offazurespringboot.Springbootsite;
 * import com.pulumi.azurenative.offazurespringboot.SpringbootsiteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var springbootsite = new Springbootsite("springbootsite", SpringbootsiteArgs.builder()
 *             .location("tgobtvxktootwhhvjtsmpddvlqlrq")
 *             .resourceGroupName("rgspringbootsites")
 *             .springbootsitesName("xrmzlavpewxtfeitghdrj")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:offazurespringboot:Springbootsite jjyngfg /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OffAzureSpringBoot/springbootsites/{springbootsitesName}
 * ```
 * @property extendedLocation The extended location definition.
 * @property location The geo-location where the resource lives
 * @property properties The springbootsites resource definition.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property springbootsitesName The springbootsites name.
 * @property tags Resource tags.
 */
public data class SpringbootsiteArgs(
    public val extendedLocation: Output<SpringbootsitesModelExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<SpringbootsitesPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val springbootsitesName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.offazurespringboot.SpringbootsiteArgs> {
    override fun toJava(): com.pulumi.azurenative.offazurespringboot.SpringbootsiteArgs =
        com.pulumi.azurenative.offazurespringboot.SpringbootsiteArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .springbootsitesName(springbootsitesName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [SpringbootsiteArgs].
 */
@PulumiTagMarker
public class SpringbootsiteArgsBuilder internal constructor() {
    private var extendedLocation: Output<SpringbootsitesModelExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<SpringbootsitesPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var springbootsitesName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The extended location definition.
     */
    @JvmName("pkvnyjmrirevjvev")
    public suspend fun extendedLocation(`value`: Output<SpringbootsitesModelExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kdedsgijgpgsidsu")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The springbootsites resource definition.
     */
    @JvmName("kbnbyxixdcjxjrhp")
    public suspend fun properties(`value`: Output<SpringbootsitesPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hpjrfddltxurgtnh")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The springbootsites name.
     */
    @JvmName("dymxkekdxtkndaov")
    public suspend fun springbootsitesName(`value`: Output<String>) {
        this.springbootsitesName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kwxrcmdeaxhvymql")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The extended location definition.
     */
    @JvmName("icbubflvunxectww")
    public suspend fun extendedLocation(`value`: SpringbootsitesModelExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location definition.
     */
    @JvmName("nayjspmkqpvjcfhb")
    public suspend
    fun extendedLocation(argument: suspend SpringbootsitesModelExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = SpringbootsitesModelExtendedLocationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("umyfliiyrfbhswqh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The springbootsites resource definition.
     */
    @JvmName("hpucyruhnigdgoio")
    public suspend fun properties(`value`: SpringbootsitesPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument The springbootsites resource definition.
     */
    @JvmName("gijswhnmvwpgaxuh")
    public suspend fun properties(argument: suspend SpringbootsitesPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SpringbootsitesPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("erjeahggkgulmuos")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The springbootsites name.
     */
    @JvmName("etmvfevxkgmvuipo")
    public suspend fun springbootsitesName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.springbootsitesName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bxnvdfddqoxieywh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("ticldberurjcegga")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): SpringbootsiteArgs = SpringbootsiteArgs(
        extendedLocation = extendedLocation,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        springbootsitesName = springbootsitesName,
        tags = tags,
    )
}
