@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin.inputs

import com.pulumi.azurenative.offazurespringboot.inputs.GetSpringbootsitePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property springbootsitesName The springbootsites name.
 */
public data class GetSpringbootsitePlainArgs(
    public val resourceGroupName: String,
    public val springbootsitesName: String,
) : ConvertibleToJava<com.pulumi.azurenative.offazurespringboot.inputs.GetSpringbootsitePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.offazurespringboot.inputs.GetSpringbootsitePlainArgs =
        com.pulumi.azurenative.offazurespringboot.inputs.GetSpringbootsitePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .springbootsitesName(springbootsitesName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSpringbootsitePlainArgs].
 */
@PulumiTagMarker
public class GetSpringbootsitePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var springbootsitesName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wktclmqiclimmvcy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The springbootsites name.
     */
    @JvmName("mlnaiodjwynomaja")
    public suspend fun springbootsitesName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.springbootsitesName = mapped
    }

    internal fun build(): GetSpringbootsitePlainArgs = GetSpringbootsitePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        springbootsitesName = springbootsitesName ?: throw PulumiNullFieldException("springbootsitesName"),
    )
}
