@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.offazurespringboot.kotlin.inputs

import com.pulumi.azurenative.offazurespringboot.inputs.SpringbootsitesModelExtendedLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The extended location definition.
 * @property name The extended location name.
 * @property type The extended location type.
 */
public data class SpringbootsitesModelExtendedLocationArgs(
    public val name: Output<String>? = null,
    public val type: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.offazurespringboot.inputs.SpringbootsitesModelExtendedLocationArgs> {
    override fun toJava():
        com.pulumi.azurenative.offazurespringboot.inputs.SpringbootsitesModelExtendedLocationArgs =
        com.pulumi.azurenative.offazurespringboot.inputs.SpringbootsitesModelExtendedLocationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpringbootsitesModelExtendedLocationArgs].
 */
@PulumiTagMarker
public class SpringbootsitesModelExtendedLocationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The extended location name.
     */
    @JvmName("qcmpisywaomvffgc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The extended location type.
     */
    @JvmName("vnurtemadndksglw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The extended location name.
     */
    @JvmName("jmfsgwfabcggidln")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The extended location type.
     */
    @JvmName("erqhixveovoxpore")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): SpringbootsitesModelExtendedLocationArgs =
        SpringbootsitesModelExtendedLocationArgs(
            name = name,
            type = type,
        )
}
