@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.openenergyplatform.kotlin

import com.pulumi.azurenative.openenergyplatform.EnergyServiceArgs.builder
import com.pulumi.azurenative.openenergyplatform.kotlin.inputs.EnergyServicePropertiesArgs
import com.pulumi.azurenative.openenergyplatform.kotlin.inputs.EnergyServicePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2022-04-04-preview. Prior API version in Azure Native 1.x: 2022-04-04-preview.
 * ## Example Usage
 * ### OepResource_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var energyService = new AzureNative.OpenEnergyPlatform.EnergyService("energyService", new()
 *     {
 *         ResourceGroupName = "DummyResourceGroupName",
 *         ResourceName = "DummyResourceName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/openenergyplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := openenergyplatform.NewEnergyService(ctx, "energyService", &openenergyplatform.EnergyServiceArgs{
 * 			ResourceGroupName: pulumi.String("DummyResourceGroupName"),
 * 			ResourceName:      pulumi.String("DummyResourceName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.openenergyplatform.EnergyService;
 * import com.pulumi.azurenative.openenergyplatform.EnergyServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var energyService = new EnergyService("energyService", EnergyServiceArgs.builder()
 *             .resourceGroupName("DummyResourceGroupName")
 *             .resourceName("DummyResourceName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:openenergyplatform:EnergyService DummyResourceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OpenEnergyPlatform/energyServices/{resourceName}
 * ```
 * @property location Geo-location where the resource lives.
 * @property properties
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The resource name.
 * @property tags Resource tags.
 */
public data class EnergyServiceArgs(
    public val location: Output<String>? = null,
    public val properties: Output<EnergyServicePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.openenergyplatform.EnergyServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.openenergyplatform.EnergyServiceArgs =
        com.pulumi.azurenative.openenergyplatform.EnergyServiceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [EnergyServiceArgs].
 */
@PulumiTagMarker
public class EnergyServiceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<EnergyServicePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Geo-location where the resource lives.
     */
    @JvmName("iytsoghyffuhgbjj")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value
     */
    @JvmName("ijwapouuvrnoqxiy")
    public suspend fun properties(`value`: Output<EnergyServicePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sdgxstukgmeeftid")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The resource name.
     */
    @JvmName("pouyeavhbkihrhry")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("upukfgerersamyao")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Geo-location where the resource lives.
     */
    @JvmName("isncqbmadlrdiyhu")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value
     */
    @JvmName("eayqaycrjfmnmuws")
    public suspend fun properties(`value`: EnergyServicePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xirmyvfjnhmtiyxn")
    public suspend fun properties(argument: suspend EnergyServicePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = EnergyServicePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yxwajvxuqnibxckc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The resource name.
     */
    @JvmName("dkwmdptwlqcwwwbn")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lhsgsdrakuuucahs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hcdmqbxmterqkqrf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): EnergyServiceArgs = EnergyServiceArgs(
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        tags = tags,
    )
}
