@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DataExport].
 */
@PulumiTagMarker
public class DataExportResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataExportArgs = DataExportArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataExportArgsBuilder.() -> Unit) {
        val builder = DataExportArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DataExport {
        val builtJavaResource =
            com.pulumi.azurenative.operationalinsights.DataExport(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataExport(builtJavaResource)
    }
}

/**
 * The top level data export resource container.
 * Azure REST API version: 2020-08-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * ## Example Usage
 * ### DataExportCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataExport = new AzureNative.OperationalInsights.DataExport("dataExport", new()
 *     {
 *         DataExportName = "export1",
 *         ResourceGroupName = "RgTest1",
 *         ResourceId = "/subscriptions/192b9f85-a39a-4276-b96d-d5cd351703f9/resourceGroups/OIAutoRest1234/providers/Microsoft.EventHub/namespaces/test",
 *         TableNames = new[]
 *         {
 *             "Heartbeat",
 *         },
 *         WorkspaceName = "DeWnTest1234",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewDataExport(ctx, "dataExport", &operationalinsights.DataExportArgs{
 * 			DataExportName:    pulumi.String("export1"),
 * 			ResourceGroupName: pulumi.String("RgTest1"),
 * 			ResourceId:        pulumi.String("/subscriptions/192b9f85-a39a-4276-b96d-d5cd351703f9/resourceGroups/OIAutoRest1234/providers/Microsoft.EventHub/namespaces/test"),
 * 			TableNames: pulumi.StringArray{
 * 				pulumi.String("Heartbeat"),
 * 			},
 * 			WorkspaceName: pulumi.String("DeWnTest1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.DataExport;
 * import com.pulumi.azurenative.operationalinsights.DataExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataExport = new DataExport("dataExport", DataExportArgs.builder()
 *             .dataExportName("export1")
 *             .resourceGroupName("RgTest1")
 *             .resourceId("/subscriptions/192b9f85-a39a-4276-b96d-d5cd351703f9/resourceGroups/OIAutoRest1234/providers/Microsoft.EventHub/namespaces/test")
 *             .tableNames("Heartbeat")
 *             .workspaceName("DeWnTest1234")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:DataExport export1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataExports/{dataExportName}
 * ```
 */
public class DataExport internal constructor(
    override val javaResource: com.pulumi.azurenative.operationalinsights.DataExport,
) : KotlinCustomResource(javaResource, DataExportMapper) {
    /**
     * The latest data export rule modification time.
     */
    public val createdDate: Output<String>?
        get() = javaResource.createdDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The data export rule ID.
     */
    public val dataExportId: Output<String>?
        get() = javaResource.dataExportId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Active when enabled.
     */
    public val enable: Output<Boolean>?
        get() = javaResource.enable().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Optional. Allows to define an Event Hub name. Not applicable when destination is Storage Account.
     */
    public val eventHubName: Output<String>?
        get() = javaResource.eventHubName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Date and time when the export was last modified.
     */
    public val lastModifiedDate: Output<String>?
        get() = javaResource.lastModifiedDate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The destination resource ID. This can be copied from the Properties entry of the destination resource in Azure.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
     */
    public val tableNames: Output<List<String>>
        get() = javaResource.tableNames().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataExportMapper : ResourceMapper<DataExport> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.operationalinsights.DataExport::class == javaResource::class

    override fun map(javaResource: Resource): DataExport = DataExport(
        javaResource as
            com.pulumi.azurenative.operationalinsights.DataExport,
    )
}

/**
 * @see [DataExport].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataExport].
 */
public suspend fun dataExport(name: String, block: suspend DataExportResourceBuilder.() -> Unit):
    DataExport {
    val builder = DataExportResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataExport].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataExport(name: String): DataExport {
    val builder = DataExportResourceBuilder()
    builder.name(name)
    return builder.build()
}
