@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.DataExportArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The top level data export resource container.
 * Azure REST API version: 2020-08-01. Prior API version in Azure Native 1.x: 2020-08-01.
 * ## Example Usage
 * ### DataExportCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataExport = new AzureNative.OperationalInsights.DataExport("dataExport", new()
 *     {
 *         DataExportName = "export1",
 *         ResourceGroupName = "RgTest1",
 *         ResourceId = "/subscriptions/192b9f85-a39a-4276-b96d-d5cd351703f9/resourceGroups/OIAutoRest1234/providers/Microsoft.EventHub/namespaces/test",
 *         TableNames = new[]
 *         {
 *             "Heartbeat",
 *         },
 *         WorkspaceName = "DeWnTest1234",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewDataExport(ctx, "dataExport", &operationalinsights.DataExportArgs{
 * 			DataExportName:    pulumi.String("export1"),
 * 			ResourceGroupName: pulumi.String("RgTest1"),
 * 			ResourceId:        pulumi.String("/subscriptions/192b9f85-a39a-4276-b96d-d5cd351703f9/resourceGroups/OIAutoRest1234/providers/Microsoft.EventHub/namespaces/test"),
 * 			TableNames: pulumi.StringArray{
 * 				pulumi.String("Heartbeat"),
 * 			},
 * 			WorkspaceName: pulumi.String("DeWnTest1234"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.DataExport;
 * import com.pulumi.azurenative.operationalinsights.DataExportArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataExport = new DataExport("dataExport", DataExportArgs.builder()
 *             .dataExportName("export1")
 *             .resourceGroupName("RgTest1")
 *             .resourceId("/subscriptions/192b9f85-a39a-4276-b96d-d5cd351703f9/resourceGroups/OIAutoRest1234/providers/Microsoft.EventHub/namespaces/test")
 *             .tableNames("Heartbeat")
 *             .workspaceName("DeWnTest1234")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:DataExport export1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/dataExports/{dataExportName}
 * ```
 * @property createdDate The latest data export rule modification time.
 * @property dataExportId The data export rule ID.
 * @property dataExportName The data export rule name.
 * @property enable Active when enabled.
 * @property eventHubName Optional. Allows to define an Event Hub name. Not applicable when destination is Storage Account.
 * @property lastModifiedDate Date and time when the export was last modified.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceId The destination resource ID. This can be copied from the Properties entry of the destination resource in Azure.
 * @property tableNames An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
 * @property workspaceName The name of the workspace.
 */
public data class DataExportArgs(
    public val createdDate: Output<String>? = null,
    public val dataExportId: Output<String>? = null,
    public val dataExportName: Output<String>? = null,
    public val enable: Output<Boolean>? = null,
    public val eventHubName: Output<String>? = null,
    public val lastModifiedDate: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val tableNames: Output<List<String>>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.DataExportArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.DataExportArgs =
        com.pulumi.azurenative.operationalinsights.DataExportArgs.builder()
            .createdDate(createdDate?.applyValue({ args0 -> args0 }))
            .dataExportId(dataExportId?.applyValue({ args0 -> args0 }))
            .dataExportName(dataExportName?.applyValue({ args0 -> args0 }))
            .enable(enable?.applyValue({ args0 -> args0 }))
            .eventHubName(eventHubName?.applyValue({ args0 -> args0 }))
            .lastModifiedDate(lastModifiedDate?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .tableNames(tableNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataExportArgs].
 */
@PulumiTagMarker
public class DataExportArgsBuilder internal constructor() {
    private var createdDate: Output<String>? = null

    private var dataExportId: Output<String>? = null

    private var dataExportName: Output<String>? = null

    private var enable: Output<Boolean>? = null

    private var eventHubName: Output<String>? = null

    private var lastModifiedDate: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var tableNames: Output<List<String>>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value The latest data export rule modification time.
     */
    @JvmName("kvwsqtpgjcdyksxm")
    public suspend fun createdDate(`value`: Output<String>) {
        this.createdDate = value
    }

    /**
     * @param value The data export rule ID.
     */
    @JvmName("kjviemitnwuoeroy")
    public suspend fun dataExportId(`value`: Output<String>) {
        this.dataExportId = value
    }

    /**
     * @param value The data export rule name.
     */
    @JvmName("lsnhrudpyimpodsv")
    public suspend fun dataExportName(`value`: Output<String>) {
        this.dataExportName = value
    }

    /**
     * @param value Active when enabled.
     */
    @JvmName("ptpymnuqmoxomvge")
    public suspend fun enable(`value`: Output<Boolean>) {
        this.enable = value
    }

    /**
     * @param value Optional. Allows to define an Event Hub name. Not applicable when destination is Storage Account.
     */
    @JvmName("lapwrhnxgyigheuk")
    public suspend fun eventHubName(`value`: Output<String>) {
        this.eventHubName = value
    }

    /**
     * @param value Date and time when the export was last modified.
     */
    @JvmName("dwglfwicodhuhbwv")
    public suspend fun lastModifiedDate(`value`: Output<String>) {
        this.lastModifiedDate = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qbrhckejtydgyijr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The destination resource ID. This can be copied from the Properties entry of the destination resource in Azure.
     */
    @JvmName("gomiqwgtavaxokff")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
     */
    @JvmName("uckjwtgpkpbrlsuv")
    public suspend fun tableNames(`value`: Output<List<String>>) {
        this.tableNames = value
    }

    @JvmName("vyahepghvbumoorn")
    public suspend fun tableNames(vararg values: Output<String>) {
        this.tableNames = Output.all(values.asList())
    }

    /**
     * @param values An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
     */
    @JvmName("mmuhsswpqjfuylbe")
    public suspend fun tableNames(values: List<Output<String>>) {
        this.tableNames = Output.all(values)
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("frsubymsiunafyjq")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value The latest data export rule modification time.
     */
    @JvmName("xqocavtbdaoerlmj")
    public suspend fun createdDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createdDate = mapped
    }

    /**
     * @param value The data export rule ID.
     */
    @JvmName("ifvkjknhaqruuyst")
    public suspend fun dataExportId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataExportId = mapped
    }

    /**
     * @param value The data export rule name.
     */
    @JvmName("yledrvsiluilsgnj")
    public suspend fun dataExportName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataExportName = mapped
    }

    /**
     * @param value Active when enabled.
     */
    @JvmName("xguwjhigewxvbcpi")
    public suspend fun enable(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enable = mapped
    }

    /**
     * @param value Optional. Allows to define an Event Hub name. Not applicable when destination is Storage Account.
     */
    @JvmName("djjdueujxrinsfmd")
    public suspend fun eventHubName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventHubName = mapped
    }

    /**
     * @param value Date and time when the export was last modified.
     */
    @JvmName("krwoldyhrchifpvv")
    public suspend fun lastModifiedDate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastModifiedDate = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lcpqktgwkuwncwbv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The destination resource ID. This can be copied from the Properties entry of the destination resource in Azure.
     */
    @JvmName("jyovbgrpnnjsotiv")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
     */
    @JvmName("nboubdlmurbaqjwo")
    public suspend fun tableNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableNames = mapped
    }

    /**
     * @param values An array of tables to export, for example: [“Heartbeat, SecurityEvent”].
     */
    @JvmName("qctrhsapydjapejf")
    public suspend fun tableNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableNames = mapped
    }

    /**
     * @param value The name of the workspace.
     */
    @JvmName("hchvxsmequdxhpys")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): DataExportArgs = DataExportArgs(
        createdDate = createdDate,
        dataExportId = dataExportId,
        dataExportName = dataExportName,
        enable = enable,
        eventHubName = eventHubName,
        lastModifiedDate = lastModifiedDate,
        resourceGroupName = resourceGroupName,
        resourceId = resourceId,
        tableNames = tableNames,
        workspaceName = workspaceName,
    )
}
