@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin

import com.pulumi.azurenative.operationalinsights.kotlin.outputs.MachineReferenceWithHintsResponse
import com.pulumi.azurenative.operationalinsights.kotlin.outputs.MachineReferenceWithHintsResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [MachineGroup].
 */
@PulumiTagMarker
public class MachineGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MachineGroupArgs = MachineGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MachineGroupArgsBuilder.() -> Unit) {
        val builder = MachineGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MachineGroup {
        val builtJavaResource =
            com.pulumi.azurenative.operationalinsights.MachineGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MachineGroup(builtJavaResource)
    }
}

/**
 * A user-defined logical grouping of machines.
 * Azure REST API version: 2015-11-01-preview. Prior API version in Azure Native 1.x: 2015-11-01-preview.
 * ## Example Usage
 * ### SMMachineGroupsUpdatePut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var machineGroup = new AzureNative.OperationalInsights.MachineGroup("machineGroup", new()
 *     {
 *         Count = 1,
 *         DisplayName = "Foo",
 *         Kind = "machineGroup",
 *         MachineGroupName = "ccfbf4bf-dc08-4371-9e9b-00a8d875d45a",
 *         Machines = new[]
 *         {
 *             {
 *                 { "id", "/subscriptions/63BE4E24-FDF0-4E9C-9342-6A5D5A359722/resourceGroups/rg-sm/providers/Microsoft.OperationalInsights/workspaces/D6F79F14-E563-469B-84B5-9286D2803B2F/machines/m-0fe4b501-7ac9-41d7-a4e1-1591a0789519" },
 *                 { "kind", "ref:machinewithhints" },
 *             },
 *         },
 *         ResourceGroupName = "rg-sm",
 *         WorkspaceName = "D6F79F14-E563-469B-84B5-9286D2803B2F",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationalinsights/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationalinsights.NewMachineGroup(ctx, "machineGroup", &operationalinsights.MachineGroupArgs{
 * 			Count:            pulumi.Int(1),
 * 			DisplayName:      pulumi.String("Foo"),
 * 			Kind:             pulumi.String("machineGroup"),
 * 			MachineGroupName: pulumi.String("ccfbf4bf-dc08-4371-9e9b-00a8d875d45a"),
 * 			Machines: []operationalinsights.MachineReferenceWithHintsArgs{
 * 				{
 * 					Id:   pulumi.String("/subscriptions/63BE4E24-FDF0-4E9C-9342-6A5D5A359722/resourceGroups/rg-sm/providers/Microsoft.OperationalInsights/workspaces/D6F79F14-E563-469B-84B5-9286D2803B2F/machines/m-0fe4b501-7ac9-41d7-a4e1-1591a0789519"),
 * 					Kind: pulumi.String("ref:machinewithhints"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg-sm"),
 * 			WorkspaceName:     pulumi.String("D6F79F14-E563-469B-84B5-9286D2803B2F"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationalinsights.MachineGroup;
 * import com.pulumi.azurenative.operationalinsights.MachineGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var machineGroup = new MachineGroup("machineGroup", MachineGroupArgs.builder()
 *             .count(1)
 *             .displayName("Foo")
 *             .kind("machineGroup")
 *             .machineGroupName("ccfbf4bf-dc08-4371-9e9b-00a8d875d45a")
 *             .machines(Map.ofEntries(
 *                 Map.entry("id", "/subscriptions/63BE4E24-FDF0-4E9C-9342-6A5D5A359722/resourceGroups/rg-sm/providers/Microsoft.OperationalInsights/workspaces/D6F79F14-E563-469B-84B5-9286D2803B2F/machines/m-0fe4b501-7ac9-41d7-a4e1-1591a0789519"),
 *                 Map.entry("kind", "ref:machinewithhints")
 *             ))
 *             .resourceGroupName("rg-sm")
 *             .workspaceName("D6F79F14-E563-469B-84B5-9286D2803B2F")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationalinsights:MachineGroup ccfbf4bf-dc08-4371-9e9b-00a8d875d45a /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/features/serviceMap/machineGroups/{machineGroupName}
 * ```
 */
public class MachineGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.operationalinsights.MachineGroup,
) : KotlinCustomResource(javaResource, MachineGroupMapper) {
    /**
     * Count of machines in this group. The value of count may be bigger than the number of machines in case of the group has been truncated due to exceeding the max number of machines a group can handle.
     */
    public val count: Output<Int>?
        get() = javaResource.count().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * User defined name for the group
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Resource ETAG.
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Type of the machine group
     */
    public val groupType: Output<String>?
        get() = javaResource.groupType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Additional resource type qualifier.
     * Expected value is 'machineGroup'.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * References of the machines in this group. The hints within each reference do not represent the current value of the corresponding fields. They are a snapshot created during the last time the machine group was updated.
     */
    public val machines: Output<List<MachineReferenceWithHintsResponse>>?
        get() = javaResource.machines().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MachineGroupMapper : ResourceMapper<MachineGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.operationalinsights.MachineGroup::class == javaResource::class

    override fun map(javaResource: Resource): MachineGroup = MachineGroup(
        javaResource as
            com.pulumi.azurenative.operationalinsights.MachineGroup,
    )
}

/**
 * @see [MachineGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MachineGroup].
 */
public suspend fun machineGroup(
    name: String,
    block: suspend MachineGroupResourceBuilder.() -> Unit,
): MachineGroup {
    val builder = MachineGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MachineGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun machineGroup(name: String): MachineGroup {
    val builder = MachineGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
