@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.GetMachineGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endTime UTC date and time specifying the end time of an interval. When not specified the service uses DateTime.UtcNow
 * @property machineGroupName Machine Group resource name.
 * @property resourceGroupName Resource group name within the specified subscriptionId.
 * @property startTime UTC date and time specifying the start time of an interval. When not specified the service uses DateTime.UtcNow - 10m
 * @property workspaceName OMS workspace containing the resources of interest.
 */
public data class GetMachineGroupPlainArgs(
    public val endTime: String? = null,
    public val machineGroupName: String,
    public val resourceGroupName: String,
    public val startTime: String? = null,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.GetMachineGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.GetMachineGroupPlainArgs =
        com.pulumi.azurenative.operationalinsights.inputs.GetMachineGroupPlainArgs.builder()
            .endTime(endTime?.let({ args0 -> args0 }))
            .machineGroupName(machineGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .startTime(startTime?.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMachineGroupPlainArgs].
 */
@PulumiTagMarker
public class GetMachineGroupPlainArgsBuilder internal constructor() {
    private var endTime: String? = null

    private var machineGroupName: String? = null

    private var resourceGroupName: String? = null

    private var startTime: String? = null

    private var workspaceName: String? = null

    /**
     * @param value UTC date and time specifying the end time of an interval. When not specified the service uses DateTime.UtcNow
     */
    @JvmName("jhkiaekiiwoiquad")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endTime = mapped
    }

    /**
     * @param value Machine Group resource name.
     */
    @JvmName("jglhjdugmeilsafy")
    public suspend fun machineGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.machineGroupName = mapped
    }

    /**
     * @param value Resource group name within the specified subscriptionId.
     */
    @JvmName("wcqjpssmwlfougiy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value UTC date and time specifying the start time of an interval. When not specified the service uses DateTime.UtcNow - 10m
     */
    @JvmName("cbbibdntyqwgibcq")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startTime = mapped
    }

    /**
     * @param value OMS workspace containing the resources of interest.
     */
    @JvmName("taakocrmotrkikbf")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetMachineGroupPlainArgs = GetMachineGroupPlainArgs(
        endTime = endTime,
        machineGroupName = machineGroupName ?: throw PulumiNullFieldException("machineGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        startTime = startTime,
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
