@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.WorkspaceFeaturesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Workspace features.
 * @property clusterResourceId Dedicated LA cluster resourceId that is linked to the workspaces.
 * @property disableLocalAuth Disable Non-AAD based Auth.
 * @property enableDataExport Flag that indicate if data should be exported.
 * @property enableLogAccessUsingOnlyResourcePermissions Flag that indicate which permission to use - resource or workspace or both.
 * @property immediatePurgeDataOn30Days Flag that describes if we want to remove the data after 30 days.
 */
public data class WorkspaceFeaturesArgs(
    public val clusterResourceId: Output<String>? = null,
    public val disableLocalAuth: Output<Boolean>? = null,
    public val enableDataExport: Output<Boolean>? = null,
    public val enableLogAccessUsingOnlyResourcePermissions: Output<Boolean>? = null,
    public val immediatePurgeDataOn30Days: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.WorkspaceFeaturesArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.WorkspaceFeaturesArgs =
        com.pulumi.azurenative.operationalinsights.inputs.WorkspaceFeaturesArgs.builder()
            .clusterResourceId(clusterResourceId?.applyValue({ args0 -> args0 }))
            .disableLocalAuth(disableLocalAuth?.applyValue({ args0 -> args0 }))
            .enableDataExport(enableDataExport?.applyValue({ args0 -> args0 }))
            .enableLogAccessUsingOnlyResourcePermissions(
                enableLogAccessUsingOnlyResourcePermissions?.applyValue({ args0 ->
                    args0
                }),
            )
            .immediatePurgeDataOn30Days(immediatePurgeDataOn30Days?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WorkspaceFeaturesArgs].
 */
@PulumiTagMarker
public class WorkspaceFeaturesArgsBuilder internal constructor() {
    private var clusterResourceId: Output<String>? = null

    private var disableLocalAuth: Output<Boolean>? = null

    private var enableDataExport: Output<Boolean>? = null

    private var enableLogAccessUsingOnlyResourcePermissions: Output<Boolean>? = null

    private var immediatePurgeDataOn30Days: Output<Boolean>? = null

    /**
     * @param value Dedicated LA cluster resourceId that is linked to the workspaces.
     */
    @JvmName("giygivrnjcdolrvh")
    public suspend fun clusterResourceId(`value`: Output<String>) {
        this.clusterResourceId = value
    }

    /**
     * @param value Disable Non-AAD based Auth.
     */
    @JvmName("eojwpwusitbxtdhm")
    public suspend fun disableLocalAuth(`value`: Output<Boolean>) {
        this.disableLocalAuth = value
    }

    /**
     * @param value Flag that indicate if data should be exported.
     */
    @JvmName("yvkhlijjegrspgio")
    public suspend fun enableDataExport(`value`: Output<Boolean>) {
        this.enableDataExport = value
    }

    /**
     * @param value Flag that indicate which permission to use - resource or workspace or both.
     */
    @JvmName("emmokxkaqhismfpx")
    public suspend fun enableLogAccessUsingOnlyResourcePermissions(`value`: Output<Boolean>) {
        this.enableLogAccessUsingOnlyResourcePermissions = value
    }

    /**
     * @param value Flag that describes if we want to remove the data after 30 days.
     */
    @JvmName("oakgwkpjvxuepxpo")
    public suspend fun immediatePurgeDataOn30Days(`value`: Output<Boolean>) {
        this.immediatePurgeDataOn30Days = value
    }

    /**
     * @param value Dedicated LA cluster resourceId that is linked to the workspaces.
     */
    @JvmName("uwggruahdrsolerb")
    public suspend fun clusterResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterResourceId = mapped
    }

    /**
     * @param value Disable Non-AAD based Auth.
     */
    @JvmName("fewntpknoornmvki")
    public suspend fun disableLocalAuth(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableLocalAuth = mapped
    }

    /**
     * @param value Flag that indicate if data should be exported.
     */
    @JvmName("qritnxtmwacuxosp")
    public suspend fun enableDataExport(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDataExport = mapped
    }

    /**
     * @param value Flag that indicate which permission to use - resource or workspace or both.
     */
    @JvmName("sbigbmloxbpvjilj")
    public suspend fun enableLogAccessUsingOnlyResourcePermissions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableLogAccessUsingOnlyResourcePermissions = mapped
    }

    /**
     * @param value Flag that describes if we want to remove the data after 30 days.
     */
    @JvmName("dtfromcfkgjradds")
    public suspend fun immediatePurgeDataOn30Days(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immediatePurgeDataOn30Days = mapped
    }

    internal fun build(): WorkspaceFeaturesArgs = WorkspaceFeaturesArgs(
        clusterResourceId = clusterResourceId,
        disableLocalAuth = disableLocalAuth,
        enableDataExport = enableDataExport,
        enableLogAccessUsingOnlyResourcePermissions = enableLogAccessUsingOnlyResourcePermissions,
        immediatePurgeDataOn30Days = immediatePurgeDataOn30Days,
    )
}
