@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.inputs

import com.pulumi.azurenative.operationalinsights.inputs.WorkspaceSkuArgs.builder
import com.pulumi.azurenative.operationalinsights.kotlin.enums.WorkspaceSkuNameEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The SKU (tier) of a workspace.
 * @property capacityReservationLevel The capacity reservation level in GB for this workspace, when CapacityReservation sku is selected.
 * @property name The name of the SKU.
 */
public data class WorkspaceSkuArgs(
    public val capacityReservationLevel: Output<Int>? = null,
    public val name: Output<Either<String, WorkspaceSkuNameEnum>>,
) : ConvertibleToJava<com.pulumi.azurenative.operationalinsights.inputs.WorkspaceSkuArgs> {
    override fun toJava(): com.pulumi.azurenative.operationalinsights.inputs.WorkspaceSkuArgs =
        com.pulumi.azurenative.operationalinsights.inputs.WorkspaceSkuArgs.builder()
            .capacityReservationLevel(capacityReservationLevel?.applyValue({ args0 -> args0 }))
            .name(
                name.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [WorkspaceSkuArgs].
 */
@PulumiTagMarker
public class WorkspaceSkuArgsBuilder internal constructor() {
    private var capacityReservationLevel: Output<Int>? = null

    private var name: Output<Either<String, WorkspaceSkuNameEnum>>? = null

    /**
     * @param value The capacity reservation level in GB for this workspace, when CapacityReservation sku is selected.
     */
    @JvmName("xqpomwwkqbvoivbw")
    public suspend fun capacityReservationLevel(`value`: Output<Int>) {
        this.capacityReservationLevel = value
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("vvuggbjhyyuaudfj")
    public suspend fun name(`value`: Output<Either<String, WorkspaceSkuNameEnum>>) {
        this.name = value
    }

    /**
     * @param value The capacity reservation level in GB for this workspace, when CapacityReservation sku is selected.
     */
    @JvmName("ycselkcskihemllk")
    public suspend fun capacityReservationLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacityReservationLevel = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("hlnktfdrqhbasbra")
    public suspend fun name(`value`: Either<String, WorkspaceSkuNameEnum>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("yfdphlnsqrihdxoe")
    public fun name(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkspaceSkuNameEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the SKU.
     */
    @JvmName("dvjbordbegucmovt")
    public fun name(`value`: WorkspaceSkuNameEnum) {
        val toBeMapped = Either.ofRight<String, WorkspaceSkuNameEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): WorkspaceSkuArgs = WorkspaceSkuArgs(
        capacityReservationLevel = capacityReservationLevel,
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
