@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationalinsights.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Datasources under OMS Workspace.
 * @property etag The ETag of the data source.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property kind The kind of the DataSource.
 * @property name The name of the resource
 * @property properties The data source properties in raw json format, each kind of data source have it's own schema.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDataSourceResult(
    public val etag: String? = null,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val properties: Any,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.operationalinsights.outputs.GetDataSourceResult):
            GetDataSourceResult = GetDataSourceResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            properties = javaType.properties(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
