@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin

import com.pulumi.azurenative.operationsmanagement.kotlin.outputs.ManagementAssociationPropertiesResponse
import com.pulumi.azurenative.operationsmanagement.kotlin.outputs.ManagementAssociationPropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ManagementAssociation].
 */
@PulumiTagMarker
public class ManagementAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagementAssociationArgs = ManagementAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagementAssociationArgsBuilder.() -> Unit) {
        val builder = ManagementAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ManagementAssociation {
        val builtJavaResource =
            com.pulumi.azurenative.operationsmanagement.ManagementAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagementAssociation(builtJavaResource)
    }
}

/**
 * The container for solution.
 * Azure REST API version: 2015-11-01-preview. Prior API version in Azure Native 1.x: 2015-11-01-preview.
 * ## Example Usage
 * ### SolutionCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementAssociation = new AzureNative.OperationsManagement.ManagementAssociation("managementAssociation", new()
 *     {
 *         Location = "East US",
 *         ManagementAssociationName = "managementAssociation1",
 *         Properties = new AzureNative.OperationsManagement.Inputs.ManagementAssociationPropertiesArgs
 *         {
 *             ApplicationId = "/subscriptions/sub1/resourcegroups/rg1/providers/Microsoft.Appliance/Appliances/appliance1",
 *         },
 *         ProviderName = "providerName",
 *         ResourceGroupName = "rg1",
 *         ResourceName = "resourceName",
 *         ResourceType = "resourceType",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/operationsmanagement/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := operationsmanagement.NewManagementAssociation(ctx, "managementAssociation", &operationsmanagement.ManagementAssociationArgs{
 * 			Location:                  pulumi.String("East US"),
 * 			ManagementAssociationName: pulumi.String("managementAssociation1"),
 * 			Properties: &operationsmanagement.ManagementAssociationPropertiesArgs{
 * 				ApplicationId: pulumi.String("/subscriptions/sub1/resourcegroups/rg1/providers/Microsoft.Appliance/Appliances/appliance1"),
 * 			},
 * 			ProviderName:      pulumi.String("providerName"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			ResourceName:      pulumi.String("resourceName"),
 * 			ResourceType:      pulumi.String("resourceType"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.operationsmanagement.ManagementAssociation;
 * import com.pulumi.azurenative.operationsmanagement.ManagementAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementAssociation = new ManagementAssociation("managementAssociation", ManagementAssociationArgs.builder()
 *             .location("East US")
 *             .managementAssociationName("managementAssociation1")
 *             .properties(Map.of("applicationId", "/subscriptions/sub1/resourcegroups/rg1/providers/Microsoft.Appliance/Appliances/appliance1"))
 *             .providerName("providerName")
 *             .resourceGroupName("rg1")
 *             .resourceName("resourceName")
 *             .resourceType("resourceType")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:operationsmanagement:ManagementAssociation managementAssociation1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{providerName}/{resourceType}/{resourceName}/providers/Microsoft.OperationsManagement/ManagementAssociations/{managementAssociationName}
 * ```
 */
public class ManagementAssociation internal constructor(
    override val javaResource: com.pulumi.azurenative.operationsmanagement.ManagementAssociation,
) : KotlinCustomResource(javaResource, ManagementAssociationMapper) {
    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties for ManagementAssociation object supported by the OperationsManagement resource provider.
     */
    public val properties: Output<ManagementAssociationPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagementAssociationMapper : ResourceMapper<ManagementAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.operationsmanagement.ManagementAssociation::class == javaResource::class

    override fun map(javaResource: Resource): ManagementAssociation =
        ManagementAssociation(
            javaResource as
                com.pulumi.azurenative.operationsmanagement.ManagementAssociation,
        )
}

/**
 * @see [ManagementAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagementAssociation].
 */
public suspend fun managementAssociation(
    name: String,
    block: suspend ManagementAssociationResourceBuilder.() -> Unit,
): ManagementAssociation {
    val builder = ManagementAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagementAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managementAssociation(name: String): ManagementAssociation {
    val builder = ManagementAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
