@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.operationsmanagement.kotlin.inputs

import com.pulumi.azurenative.operationsmanagement.inputs.GetManagementAssociationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementAssociationName User ManagementAssociation Name.
 * @property providerName Provider name for the parent resource.
 * @property resourceGroupName The name of the resource group to get. The name is case insensitive.
 * @property resourceName Parent resource name.
 * @property resourceType Resource type for the parent resource
 */
public data class GetManagementAssociationPlainArgs(
    public val managementAssociationName: String,
    public val providerName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
    public val resourceType: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.operationsmanagement.inputs.GetManagementAssociationPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.operationsmanagement.inputs.GetManagementAssociationPlainArgs =
        com.pulumi.azurenative.operationsmanagement.inputs.GetManagementAssociationPlainArgs.builder()
            .managementAssociationName(managementAssociationName.let({ args0 -> args0 }))
            .providerName(providerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 }))
            .resourceType(resourceType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagementAssociationPlainArgs].
 */
@PulumiTagMarker
public class GetManagementAssociationPlainArgsBuilder internal constructor() {
    private var managementAssociationName: String? = null

    private var providerName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    private var resourceType: String? = null

    /**
     * @param value User ManagementAssociation Name.
     */
    @JvmName("efmueqnjtsjnjejp")
    public suspend fun managementAssociationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementAssociationName = mapped
    }

    /**
     * @param value Provider name for the parent resource.
     */
    @JvmName("ogrqtmhyespamoqv")
    public suspend fun providerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerName = mapped
    }

    /**
     * @param value The name of the resource group to get. The name is case insensitive.
     */
    @JvmName("yhntjyuvqjdmjccm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Parent resource name.
     */
    @JvmName("dkloatshibenhesd")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    /**
     * @param value Resource type for the parent resource
     */
    @JvmName("dlyjajyvqktpndok")
    public suspend fun resourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceType = mapped
    }

    internal fun build(): GetManagementAssociationPlainArgs = GetManagementAssociationPlainArgs(
        managementAssociationName = managementAssociationName ?: throw
            PulumiNullFieldException("managementAssociationName"),
        providerName = providerName ?: throw PulumiNullFieldException("providerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        resourceType = resourceType ?: throw PulumiNullFieldException("resourceType"),
    )
}
