@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.orbital.kotlin

import com.pulumi.azurenative.orbital.SpacecraftArgs.builder
import com.pulumi.azurenative.orbital.kotlin.inputs.SpacecraftLinkArgs
import com.pulumi.azurenative.orbital.kotlin.inputs.SpacecraftLinkArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Customer creates a spacecraft resource to schedule a contact.
 * Azure REST API version: 2022-11-01.
 * Other available API versions: 2022-03-01.
 * ## Example Usage
 * ### Create a spacecraft
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var spacecraft = new AzureNative.Orbital.Spacecraft("spacecraft", new()
 *     {
 *         Links = new[]
 *         {
 *             new AzureNative.Orbital.Inputs.SpacecraftLinkArgs
 *             {
 *                 BandwidthMHz = 2,
 *                 CenterFrequencyMHz = 2250,
 *                 Direction = "Uplink",
 *                 Name = "uplink_lhcp1",
 *                 Polarization = "LHCP",
 *             },
 *             new AzureNative.Orbital.Inputs.SpacecraftLinkArgs
 *             {
 *                 BandwidthMHz = 15,
 *                 CenterFrequencyMHz = 8160,
 *                 Direction = "Downlink",
 *                 Name = "downlink_rhcp1",
 *                 Polarization = "RHCP",
 *             },
 *         },
 *         Location = "eastus2",
 *         NoradId = "36411",
 *         ResourceGroupName = "contoso-Rgp",
 *         SpacecraftName = "CONTOSO_SAT",
 *         TitleLine = "CONTOSO_SAT",
 *         TleLine1 = "1 27424U 02022A   22167.05119303  .00000638  00000+0  15103-3 0  9994",
 *         TleLine2 = "2 27424  98.2477 108.9546 0000928  92.9194 327.0802 14.57300770 69982",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/orbital/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := orbital.NewSpacecraft(ctx, "spacecraft", &orbital.SpacecraftArgs{
 * 			Links: []orbital.SpacecraftLinkArgs{
 * 				{
 * 					BandwidthMHz:       pulumi.Float64(2),
 * 					CenterFrequencyMHz: pulumi.Float64(2250),
 * 					Direction:          pulumi.String("Uplink"),
 * 					Name:               pulumi.String("uplink_lhcp1"),
 * 					Polarization:       pulumi.String("LHCP"),
 * 				},
 * 				{
 * 					BandwidthMHz:       pulumi.Float64(15),
 * 					CenterFrequencyMHz: pulumi.Float64(8160),
 * 					Direction:          pulumi.String("Downlink"),
 * 					Name:               pulumi.String("downlink_rhcp1"),
 * 					Polarization:       pulumi.String("RHCP"),
 * 				},
 * 			},
 * 			Location:          pulumi.String("eastus2"),
 * 			NoradId:           pulumi.String("36411"),
 * 			ResourceGroupName: pulumi.String("contoso-Rgp"),
 * 			SpacecraftName:    pulumi.String("CONTOSO_SAT"),
 * 			TitleLine:         pulumi.String("CONTOSO_SAT"),
 * 			TleLine1:          pulumi.String("1 27424U 02022A   22167.05119303  .00000638  00000+0  15103-3 0  9994"),
 * 			TleLine2:          pulumi.String("2 27424  98.2477 108.9546 0000928  92.9194 327.0802 14.57300770 69982"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.orbital.Spacecraft;
 * import com.pulumi.azurenative.orbital.SpacecraftArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var spacecraft = new Spacecraft("spacecraft", SpacecraftArgs.builder()
 *             .links(
 *                 Map.ofEntries(
 *                     Map.entry("bandwidthMHz", 2),
 *                     Map.entry("centerFrequencyMHz", 2250),
 *                     Map.entry("direction", "Uplink"),
 *                     Map.entry("name", "uplink_lhcp1"),
 *                     Map.entry("polarization", "LHCP")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("bandwidthMHz", 15),
 *                     Map.entry("centerFrequencyMHz", 8160),
 *                     Map.entry("direction", "Downlink"),
 *                     Map.entry("name", "downlink_rhcp1"),
 *                     Map.entry("polarization", "RHCP")
 *                 ))
 *             .location("eastus2")
 *             .noradId("36411")
 *             .resourceGroupName("contoso-Rgp")
 *             .spacecraftName("CONTOSO_SAT")
 *             .titleLine("CONTOSO_SAT")
 *             .tleLine1("1 27424U 02022A   22167.05119303  .00000638  00000+0  15103-3 0  9994")
 *             .tleLine2("2 27424  98.2477 108.9546 0000928  92.9194 327.0802 14.57300770 69982")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:orbital:Spacecraft CONTOSO_SAT /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Orbital/spacecrafts/{spacecraftName}
 * ```
 * @property links Immutable list of Spacecraft links.
 * @property location The geo-location where the resource lives
 * @property noradId NORAD ID of the spacecraft.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property spacecraftName Spacecraft ID.
 * @property tags Resource tags.
 * @property titleLine Title line of the two-line element set (TLE).
 * @property tleLine1 Line 1 of the two-line element set (TLE).
 * @property tleLine2 Line 2 of the two-line element set (TLE).
 */
public data class SpacecraftArgs(
    public val links: Output<List<SpacecraftLinkArgs>>? = null,
    public val location: Output<String>? = null,
    public val noradId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val spacecraftName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val titleLine: Output<String>? = null,
    public val tleLine1: Output<String>? = null,
    public val tleLine2: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.orbital.SpacecraftArgs> {
    override fun toJava(): com.pulumi.azurenative.orbital.SpacecraftArgs =
        com.pulumi.azurenative.orbital.SpacecraftArgs.builder()
            .links(links?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .noradId(noradId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .spacecraftName(spacecraftName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .titleLine(titleLine?.applyValue({ args0 -> args0 }))
            .tleLine1(tleLine1?.applyValue({ args0 -> args0 }))
            .tleLine2(tleLine2?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SpacecraftArgs].
 */
@PulumiTagMarker
public class SpacecraftArgsBuilder internal constructor() {
    private var links: Output<List<SpacecraftLinkArgs>>? = null

    private var location: Output<String>? = null

    private var noradId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var spacecraftName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var titleLine: Output<String>? = null

    private var tleLine1: Output<String>? = null

    private var tleLine2: Output<String>? = null

    /**
     * @param value Immutable list of Spacecraft links.
     */
    @JvmName("tidgaicsxjugivdk")
    public suspend fun links(`value`: Output<List<SpacecraftLinkArgs>>) {
        this.links = value
    }

    @JvmName("nnssfjrtepoodidd")
    public suspend fun links(vararg values: Output<SpacecraftLinkArgs>) {
        this.links = Output.all(values.asList())
    }

    /**
     * @param values Immutable list of Spacecraft links.
     */
    @JvmName("ystvbnnkavmbfxau")
    public suspend fun links(values: List<Output<SpacecraftLinkArgs>>) {
        this.links = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("sexorjqcrddyakru")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value NORAD ID of the spacecraft.
     */
    @JvmName("bdtnlfngvigivljf")
    public suspend fun noradId(`value`: Output<String>) {
        this.noradId = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oeudxkvlfmkasjvq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Spacecraft ID.
     */
    @JvmName("rbwvhxbodlqpknuk")
    public suspend fun spacecraftName(`value`: Output<String>) {
        this.spacecraftName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("grtgnxrttliyhbjf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Title line of the two-line element set (TLE).
     */
    @JvmName("skfogdortraaeasg")
    public suspend fun titleLine(`value`: Output<String>) {
        this.titleLine = value
    }

    /**
     * @param value Line 1 of the two-line element set (TLE).
     */
    @JvmName("txggqggijpocnrya")
    public suspend fun tleLine1(`value`: Output<String>) {
        this.tleLine1 = value
    }

    /**
     * @param value Line 2 of the two-line element set (TLE).
     */
    @JvmName("oxmqudbtldvruqtv")
    public suspend fun tleLine2(`value`: Output<String>) {
        this.tleLine2 = value
    }

    /**
     * @param value Immutable list of Spacecraft links.
     */
    @JvmName("fdadixgcqtqweplt")
    public suspend fun links(`value`: List<SpacecraftLinkArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.links = mapped
    }

    /**
     * @param argument Immutable list of Spacecraft links.
     */
    @JvmName("asnycgssycqwlqdu")
    public suspend fun links(argument: List<suspend SpacecraftLinkArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SpacecraftLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param argument Immutable list of Spacecraft links.
     */
    @JvmName("tblidinhdnruyeaq")
    public suspend fun links(vararg argument: suspend SpacecraftLinkArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SpacecraftLinkArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param argument Immutable list of Spacecraft links.
     */
    @JvmName("fwwvvyshuanhcqqk")
    public suspend fun links(argument: suspend SpacecraftLinkArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SpacecraftLinkArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.links = mapped
    }

    /**
     * @param values Immutable list of Spacecraft links.
     */
    @JvmName("lvfwstujrfxgwefk")
    public suspend fun links(vararg values: SpacecraftLinkArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.links = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hypguaayeiosxbok")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value NORAD ID of the spacecraft.
     */
    @JvmName("ujbtqlmniuxaguwv")
    public suspend fun noradId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noradId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ypfudljnkhcbyjvi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Spacecraft ID.
     */
    @JvmName("oyjhorefcrcnaqle")
    public suspend fun spacecraftName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spacecraftName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tgtsqhdtyodqsdye")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("bbfepwevupiqhkcq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Title line of the two-line element set (TLE).
     */
    @JvmName("abexemmvhfhajjla")
    public suspend fun titleLine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.titleLine = mapped
    }

    /**
     * @param value Line 1 of the two-line element set (TLE).
     */
    @JvmName("ryegcuhcjhlinbqh")
    public suspend fun tleLine1(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tleLine1 = mapped
    }

    /**
     * @param value Line 2 of the two-line element set (TLE).
     */
    @JvmName("oqfwjadttkupnamu")
    public suspend fun tleLine2(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tleLine2 = mapped
    }

    internal fun build(): SpacecraftArgs = SpacecraftArgs(
        links = links,
        location = location,
        noradId = noradId,
        resourceGroupName = resourceGroupName,
        spacecraftName = spacecraftName,
        tags = tags,
        titleLine = titleLine,
        tleLine1 = tleLine1,
        tleLine2 = tleLine2,
    )
}
